/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.TargetType;

public class ValidateArg
extends OperationArg {
    private TargetType sourceCfgType;
    boolean config;
    private String sourceUrl;
    private String configContent;

    public ValidateArg(String configContent) {
        this.config = true;
        this.configContent = configContent;
    }

    public ValidateArg(TargetType sourceCfgType, String sourceUrl) throws NetconfException {
        this.config = false;
        this.sourceCfgType = sourceCfgType;
        this.sourceUrl = sourceUrl;
    }

    public TargetType getSourceCfgType() {
        return this.sourceCfgType;
    }

    public void setSourceCfgType(TargetType sourceCfgType) {
        this.sourceCfgType = sourceCfgType;
    }

    public boolean isConfig() {
        return this.config;
    }

    public void setConfig(boolean config) {
        this.config = config;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getConfigContent() {
        return this.configContent;
    }

    public void setConfigContent(String configContent) {
        this.configContent = configContent;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((0x20 & deviceCapability) == 0) {
            return false;
        }
        if (this.sourceCfgType == TargetType.CDB && (4 & deviceCapability) == 0) {
            return false;
        }
        if (this.sourceCfgType == TargetType.URL && (0x80 & deviceCapability) == 0) {
            return false;
        }
        return this.sourceCfgType != TargetType.STARTUP || (0x40 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuffer buf = new StringBuffer("<validate>");
        if (this.config) {
            buf.append("<source><config>").append(this.configContent).append("</config></source>");
        } else {
            if (TargetType.CDB == this.sourceCfgType) {
                buf.append("<source><candidate/></source>");
            }
            if (TargetType.URL == this.sourceCfgType) {
                buf.append("<source><url>").append(this.sourceUrl).append("</url></source>");
            }
            if (TargetType.STARTUP == this.sourceCfgType) {
                buf.append("<source><startup/></source>");
            }
        }
        buf.append("</validate>");
        return buf.toString();
    }
}

