/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.TargetType;

public class UnLockArg
extends OperationArg {
    private TargetType targetCfgType;

    @Deprecated
    public UnLockArg(int type) throws NetconfException {
        switch (type) {
            case 2: {
                this.targetCfgType = TargetType.CDB;
                break;
            }
            case 5: {
                this.targetCfgType = TargetType.CHECKPOINT;
                break;
            }
            case 1: {
                this.targetCfgType = TargetType.RDB;
                break;
            }
            case 3: {
                this.targetCfgType = TargetType.STARTUP;
                break;
            }
        }
    }

    public UnLockArg(TargetType targetCfgType) throws NetconfException {
        this.targetCfgType = targetCfgType;
    }

    public TargetType getTargetCfgType() {
        return this.targetCfgType;
    }

    public void setTargetCfgType(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return this.targetCfgType != TargetType.CDB || (4 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<unlock><target>");
        if (TargetType.RDB == this.targetCfgType) {
            buf.append("<running/>");
        } else if (TargetType.CDB == this.targetCfgType) {
            buf.append("<candidate/>");
        } else if (TargetType.STARTUP == this.targetCfgType) {
            buf.append("<startup/>");
        }
        buf.append("</target></unlock>");
        return buf.toString();
    }
}

