/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;

public class SyncIncrementArg
extends OperationArg {
    private FilterType filter;
    private long sourceSetId;
    private long targetSetId;

    public SyncIncrementArg(FilterType filter, long sourceSetId, long targetSetId) throws NetconfException {
        if (targetSetId <= sourceSetId || targetSetId <= 0L) {
            throw new NetconfException(-1);
        }
        this.filter = filter;
        this.sourceSetId = sourceSetId;
        if (this.sourceSetId < 0L) {
            this.sourceSetId = 0L;
        }
        this.targetSetId = targetSetId;
    }

    public SyncIncrementArg(int sourceSetId, int targetSetId) throws NetconfException {
        if (targetSetId < sourceSetId || sourceSetId <= 0 || targetSetId <= 0) {
            throw new NetconfException(-1);
        }
        this.sourceSetId = sourceSetId;
        this.targetSetId = targetSetId;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((0x2004 & deviceCapability) == 0) {
            return false;
        }
        return this.filter != FilterType.XPATH || (0x100 & deviceCapability) != 0;
    }

    public FilterType getFilterType() {
        return this.filter;
    }

    public long getSourceSetId() {
        return this.sourceSetId;
    }

    public long getTargetSetId() {
        return this.targetSetId;
    }

    @Override
    public boolean isKeepAlive() {
        return true;
    }

    public void setFilterType(FilterType filter) {
        this.filter = filter;
    }

    public void setSourceSetId(long sourceSetId) {
        this.sourceSetId = sourceSetId;
    }

    public void setTargetSetId(int targetSetId) {
        this.targetSetId = targetSetId;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<sync-increment xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\">");
        buf.append("<target><flow-id>").append(this.targetSetId).append("</flow-id></target>");
        buf.append("<source><flow-id>").append(this.sourceSetId).append("</flow-id></source>");
        if (this.filter == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">").append(this.getContent()).append("</filter>");
        } else if (this.filter == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"").append(this.getContent()).append("\"/>");
        }
        buf.append("</sync-increment>");
        return buf.toString();
    }
}

