/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.SyncFullArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.tool.PlatformCipherTool;
import com.huawei.vmf.netconf.util.VTDNavAdapter;

public class SyncFullArgBySFTP
extends SyncFullArg {
    public SyncFullArgBySFTP(FilterType filter, String fileName, String user, String password, String ftpIp, int port, String path) {
        super(filter, fileName, user, password, ftpIp, port, path);
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<sync-full xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><target>");
        buf.append("<user-name>").append(VTDNavAdapter.encodeXmlText(this.getUser())).append("</user-name>");
        buf.append("<password>").append(PlatformCipherTool.markPwd(VTDNavAdapter.encodeXmlText(this.getPassword()))).append("</password>");
        buf.append("<target-addr>").append(this.getFtpIp()).append(':').append(this.getPort()).append("</target-addr>");
        buf.append("<path>").append(this.getPath()).append("</path>");
        buf.append("</target>");
        buf.append("<transfer-protocol>").append("SFTP").append("</transfer-protocol>");
        buf.append("<filename-prefix>").append(this.getFileName()).append("</filename-prefix>");
        if (this.getFilter() == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">").append(this.getContent()).append("</filter>");
        } else if (this.getFilter() == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"").append(this.getContent()).append("\"/>");
        }
        buf.append("</sync-full>");
        return buf.toString();
    }

    @Override
    public String toLogCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<sync-full xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><target>");
        buf.append("<user-name>").append(VTDNavAdapter.encodeXmlText(this.getUser())).append("</user-name>");
        buf.append("<password>").append("........").append("</password>");
        buf.append("<target-addr>").append(this.getFtpIp()).append(':').append(this.getPort()).append("</target-addr>");
        buf.append("<path>").append(this.getPath()).append("</path>");
        buf.append("</target>");
        buf.append("<transfer-protocol>").append("SFTP").append("</transfer-protocol>");
        buf.append("<filename-prefix>").append(this.getFileName()).append("</filename-prefix>");
        if (this.getFilter() == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">").append(this.getContent()).append("</filter>");
        } else if (this.getFilter() == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"").append(this.getContent()).append("\"/>");
        }
        buf.append("</sync-full>");
        return buf.toString();
    }
}

