/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.tool.PlatformCipherTool;
import com.huawei.vmf.netconf.util.VTDNavAdapter;

public class SyncFullArg
extends OperationArg {
    private String fileName;
    private FilterType filter;
    private String ftpIp;
    private String ftpType;
    private String password;
    private String path;
    private int port;
    private String user;

    public SyncFullArg(FilterType filter, String fileName, String user, String password, String ftpIp, int port, String path) {
        this.filter = filter;
        this.fileName = fileName;
        this.user = user;
        this.password = password;
        this.ftpIp = ftpIp;
        this.port = port;
        this.path = path;
    }

    public SyncFullArg(FilterType filter, String fileName, String user, String password, String ftpIp, int port, String path, String ftpType) {
        this.filter = filter;
        this.fileName = fileName;
        this.user = user;
        this.password = password;
        this.ftpIp = ftpIp;
        this.port = port;
        this.path = path;
        this.ftpType = ftpType;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((0x2004 & deviceCapability) == 0) {
            return false;
        }
        return this.filter != FilterType.XPATH || (0x100 & deviceCapability) != 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FilterType getFilter() {
        return this.filter;
    }

    public FilterType getFilterType() {
        return this.filter;
    }

    public String getFtpIp() {
        return this.ftpIp;
    }

    public String getFtpType() {
        return this.ftpType;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isKeepAlive() {
        return true;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilterType(FilterType filter) {
        this.filter = filter;
    }

    public void setFtpType(String ftpType) {
        this.ftpType = ftpType;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<sync-full xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><target>");
        buf.append("<user-name>").append(VTDNavAdapter.encodeXmlText(this.user)).append("</user-name>");
        buf.append("<password>").append(PlatformCipherTool.markPwd(VTDNavAdapter.encodeXmlText(this.password))).append("</password>");
        buf.append("<target-addr>").append(this.ftpIp).append(':').append(this.port).append("</target-addr>");
        buf.append("<path>").append(this.path).append("</path>");
        buf.append("</target>");
        buf.append("<filename-prefix>").append(this.fileName).append("</filename-prefix>");
        if (this.filter == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">").append(this.getContent()).append("</filter>");
        } else if (this.filter == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"").append(this.getContent()).append("\"/>");
        }
        buf.append("</sync-full>");
        return buf.toString();
    }

    @Override
    public String toLogCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<sync-full xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><target>");
        buf.append("<user-name>").append(VTDNavAdapter.encodeXmlText(this.user)).append("</user-name>");
        buf.append("<password>").append("........").append("</password>");
        buf.append("<target-addr>").append(this.ftpIp).append(':').append(this.port).append("</target-addr>");
        buf.append("<path>").append(this.path).append("</path>");
        buf.append("</target>");
        buf.append("<filename-prefix>").append(this.fileName).append("</filename-prefix>");
        if (this.filter == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">").append(this.getContent()).append("</filter>");
        } else if (this.filter == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"").append(this.getContent()).append("\"/>");
        }
        buf.append("</sync-full>");
        return buf.toString();
    }
}

