/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;

public class SaveCheckPointArg
extends OperationArg {
    private String checkPointName;
    private String description;

    public SaveCheckPointArg(String checkPointName, String description) throws NetconfException {
        if (null == checkPointName || null == description) {
            throw new NetconfException(-1);
        }
        this.checkPointName = checkPointName;
        this.description = description;
    }

    public String getCheckPointName() {
        return this.checkPointName;
    }

    public void setCheckPointName(String checkPointName) {
        this.checkPointName = checkPointName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return (0x404 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<save-checkpoint");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><checkpoint>");
        buf.append(this.checkPointName);
        buf.append("</checkpoint>");
        if (this.description != null && !"".equals(this.description)) {
            buf.append("<description>").append(this.description).append("</description>");
        }
        buf.append("</save-checkpoint>");
        return buf.toString();
    }
}

