/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.tool.XmlUtil;
import com.huawei.vmf.netconf.util.HWContextUtil;
import com.huawei.vmf.netconf.util.VTDNavAdapter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RspCmd
implements IRpcReply {
    private String content;
    private List<RpcErrorInfo> errorInfos;
    private int flowID = -1;
    private int setID = -1;
    private int messageID = -1;
    private List<IRpcReply> packages;
    private boolean active;
    private Integer lrID;
    private Integer vrID;
    private int fullSyncId = -1;
    @Deprecated
    public static final int CONTENT = 3;
    @Deprecated
    public static final int ERROR = 2;
    @Deprecated
    public static final int OK = 1;

    public void setVrID(Integer vrID) {
        this.vrID = vrID;
    }

    public RspCmd() {
    }

    public RspCmd(String rpcReply) throws BadMessageFormatException {
        if (rpcReply == null) {
            return;
        }
        XMLInputFactory factory = XmlUtil.newXMLInputFactory();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(rpcReply.trim()));
            while (reader.hasNext()) {
                int event = reader.next();
                if (event != 1 || !"rpc-reply".equals(reader.getLocalName()) && !"active".equals(reader.getLocalName())) continue;
                this.init(reader);
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new BadMessageFormatException("rpc-reply is not illegal.", (Throwable)e);
        }
    }

    public RspCmd(XMLStreamReader reader) throws BadMessageFormatException {
        try {
            this.init(reader);
        }
        catch (XMLStreamException e) {
            throw new BadMessageFormatException("rpc-reply is not illegal.", (Throwable)e);
        }
    }

    private void init(XMLStreamReader reader) throws BadMessageFormatException, XMLStreamException {
        if ("rpc-reply".equals(reader.getLocalName())) {
            this.messageID = VTDNavAdapter.getIntAttribute(reader, "message-id", -1);
            String context = VTDNavAdapter.getStringAttribute(reader, "hwcontext", "");
            Map<String, Integer> map = HWContextUtil.lrvrValue(context);
            this.lrID = null == map.get("ls") ? 0 : map.get("ls");
            this.vrID = null == map.get("vs") ? 0 : map.get("vs");
            this.setID = VTDNavAdapter.getIntAttribute(reader, "set-id", -1);
            this.flowID = VTDNavAdapter.getIntAttribute(reader, "flow-id", -1);
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1) {
                    this.parseElement(reader);
                    continue;
                }
                if (event != 2 || !"rpc-reply".equals(reader.getLocalName())) continue;
                return;
            }
        } else if ("active".equals(reader.getLocalName())) {
            this.messageID = VTDNavAdapter.getIntAttribute(reader, "message-id", -1);
            this.active = true;
        } else {
            throw new BadMessageFormatException("expected <rpc-reply> but actual is " + reader.getLocalName(), null);
        }
    }

    private void parseElement(XMLStreamReader reader) throws XMLStreamException, BadMessageFormatException {
        String name = reader.getLocalName();
        if ("data".equals(name)) {
            this.content = VTDNavAdapter.getElementText(reader, "data");
        } else if ("rpc-error".equals(name)) {
            RpcErrorInfo error = new RpcErrorInfo(reader);
            if (this.errorInfos == null) {
                this.errorInfos = new ArrayList<RpcErrorInfo>();
            }
            this.errorInfos.add(error);
        }
    }

    @Override
    public void addPackage(IRpcReply reply) {
        if (reply == null) {
            return;
        }
        if (this.packages == null) {
            this.packages = new ArrayList<IRpcReply>();
        }
        this.packages.add(reply);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Collection<RpcErrorInfo> getErrorInfos() {
        return this.errorInfos;
    }

    public void addErrorInfo(RpcErrorInfo errorInfo) {
        if (this.errorInfos == null) {
            this.errorInfos = new LinkedList<RpcErrorInfo>();
        }
        this.errorInfos.add(errorInfo);
    }

    @Override
    public int getMessageID() {
        return this.messageID;
    }

    @Override
    public Collection<IRpcReply> getPackages() {
        if (this.packages == null) {
            return Collections.emptyList();
        }
        return this.packages;
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public boolean hasNext() {
        return this.setID > 0;
    }

    @Override
    public boolean isOK() {
        return this.errorInfos == null || this.errorInfos.isEmpty();
    }

    @Override
    public int getFlowID() {
        return this.flowID;
    }

    public void setFlowID(int flowID) {
        this.flowID = flowID;
    }

    public void setSetID(int setID) {
        this.setID = setID;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RspCmd [messageID=");
        builder.append(this.messageID);
        builder.append("]");
        return builder.toString();
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Deprecated
    public int getType() {
        if (this.getContent() != null) {
            return 3;
        }
        if (this.getErrorInfos() != null && !this.getErrorInfos().isEmpty()) {
            return 2;
        }
        return 1;
    }

    @Deprecated
    public List<RpcErrorInfo> getErrorInfo() {
        return this.errorInfos;
    }

    @Deprecated
    public String getContentData() {
        return this.content;
    }

    @Override
    public Integer getLrID() {
        return this.lrID;
    }

    @Override
    public Integer getVrID() {
        return this.vrID;
    }

    public int getFullSyncId() {
        return this.fullSyncId;
    }
}

