/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.util.VTDNavAdapter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RpcErrorInfo {
    private String errAppTag;
    private String errInfo;
    private String errMsg;
    private String errSeverity;
    private String errTag;
    private String errType;

    public RpcErrorInfo(XMLStreamReader reader) throws BadMessageFormatException {
        block5: {
            try {
                if ("rpc-error".equals(reader.getLocalName())) {
                    while (reader.hasNext()) {
                        int event = reader.next();
                        if (event == 1) {
                            this.parseElement(reader);
                            continue;
                        }
                        if (event != 2 || !"rpc-error".equals(reader.getLocalName())) continue;
                        return;
                    }
                    break block5;
                }
                throw new BadMessageFormatException("expected <rpc-error> but actual is " + reader.getLocalName(), null);
            }
            catch (XMLStreamException e) {
                throw new BadMessageFormatException("rpc-error is not illegal.", (Throwable)e);
            }
        }
    }

    private void parseElement(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getLocalName();
        if ("error-type".equals(name)) {
            this.errType = VTDNavAdapter.getElementText(reader, "error-type");
        } else if ("error-tag".equals(name)) {
            this.errTag = VTDNavAdapter.getElementText(reader, "error-tag");
        } else if ("error-severity".equals(name)) {
            this.errSeverity = VTDNavAdapter.getElementText(reader, "error-severity");
        } else if ("error-app-tag".equals(name)) {
            this.errAppTag = VTDNavAdapter.getElementText(reader, "error-app-tag");
        } else if ("error-message".equals(name)) {
            this.errMsg = VTDNavAdapter.getElementText(reader, "error-message");
        } else if ("error-info".equals(name)) {
            this.errInfo = VTDNavAdapter.getElementText(reader, "error-info");
        }
    }

    public RpcErrorInfo(String errAppTag, String errInfo, String errMsg, String errSeverity, String errTag, String errType) throws NetconfException {
        this.errAppTag = errAppTag;
        this.errInfo = errInfo;
        this.errMsg = errMsg;
        this.errSeverity = errSeverity;
        this.errTag = errTag;
        this.errType = errType;
    }

    public RpcErrorInfo() {
    }

    public String getErrAppTag() {
        return this.errAppTag;
    }

    public void setErrAppTag(String errAppTag) {
        this.errAppTag = errAppTag;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getErrSeverity() {
        return this.errSeverity;
    }

    public void setErrSeverity(String errSeverity) {
        this.errSeverity = errSeverity;
    }

    public String getErrTag() {
        return this.errTag;
    }

    public void setErrTag(String errTag) {
        this.errTag = errTag;
    }

    public String getErrType() {
        return this.errType;
    }

    public void setErrType(String errType) {
        this.errType = errType;
    }

    @Deprecated
    public String getErrPath() {
        return "";
    }
}

