/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;

public class RollbackConfigArg
extends OperationArg {
    private String checkPointName;

    public RollbackConfigArg(String checkPointName) throws NetconfException {
        if (null == checkPointName) {
            throw new NetconfException(-1);
        }
        this.checkPointName = checkPointName;
    }

    public String getCheckPointName() {
        return this.checkPointName;
    }

    public void setCheckPointName(String checkPointName) {
        this.checkPointName = checkPointName;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return (0x404 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder();
        buf.append("<rollback-config");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\"><checkpoint>");
        buf.append(this.checkPointName);
        buf.append("</checkpoint></rollback-config>");
        return buf.toString();
    }
}

