/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.datadefination.RpcArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.session.NetconfAbility;
import com.huawei.vmf.netconf.util.HWContextUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReqCmd
implements IRpc {
    private boolean enableGetNext;
    private Integer lrID;
    private OperationArg operationArg;
    private List<RpcArg> rpcArgs;
    private long timeout;
    private Integer vrID;

    public ReqCmd(List<RpcArg> rpcArgs, OperationArg operationArg, boolean enableGetNext) {
        this.enableGetNext = enableGetNext;
        this.rpcArgs = rpcArgs;
        this.operationArg = operationArg;
        this.initLrVr();
    }

    @Deprecated
    public ReqCmd(String content, String logContent, boolean enableGetNext, List<RpcArg> rpcArgs, OperationArg operationArg) {
        this.enableGetNext = enableGetNext;
        this.rpcArgs = rpcArgs;
        this.operationArg = operationArg;
        if (operationArg != null) {
            operationArg.setContent(content);
            operationArg.setLogContent(logContent);
        }
        this.initLrVr();
    }

    @Override
    public boolean capable(NetconfAbility abilityVolumn) {
        int deviceAbilityVolumn = abilityVolumn.getDeviceAbilityVolumn();
        return this.operationArg.capable(deviceAbilityVolumn);
    }

    @Override
    public String getContent() {
        return this.operationArg.getContent();
    }

    @Override
    public Integer getLrID() {
        return this.lrID;
    }

    public OperationArg getOperationArg() {
        return this.operationArg;
    }

    public List<RpcArg> getRpcArgList() {
        return this.rpcArgs;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getVrID() {
        return this.vrID;
    }

    public boolean isEnableGetNext() {
        return this.enableGetNext;
    }

    @Override
    public boolean isKeepAlive() {
        if (this.operationArg != null) {
            return this.operationArg.isKeepAlive();
        }
        return false;
    }

    public void setEnableGetNext(boolean enableGetNext) {
        this.enableGetNext = enableGetNext;
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        if (this.operationArg != null) {
            this.operationArg.setKeepAlive(keepAlive);
        }
    }

    public void setOperationArg(OperationArg operationArg) {
        this.operationArg = operationArg;
    }

    public void setRpcArgList(List<RpcArg> rpcArgList) {
        this.rpcArgs = rpcArgList;
        this.initLrVr();
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public String toCommand(int messageID) throws NetconfException {
        StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append("<rpc message-id=\"");
        buf.append(messageID);
        buf.append("\"");
        if (null != this.rpcArgs) {
            Iterator<RpcArg> iter = this.rpcArgs.iterator();
            RpcArg arg = null;
            while (iter.hasNext()) {
                arg = iter.next();
                String key = arg.getName();
                String value = arg.getValue();
                buf.append(' ');
                buf.append(key);
                buf.append("=\"");
                buf.append(value);
                buf.append("\"");
            }
        }
        buf.append(" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        if (this.operationArg != null) {
            buf.append(this.operationArg.toCommand());
        }
        buf.append("</rpc>");
        return buf.toString();
    }

    private void initLrVr() {
        if (null == this.rpcArgs) {
            return;
        }
        for (RpcArg rpcArg : this.rpcArgs) {
            if (null == rpcArg || !"hwcontext".equals(rpcArg.getName())) continue;
            Map<String, Integer> lrvrValue = HWContextUtil.lrvrValue(rpcArg.getValue());
            this.lrID = lrvrValue.get("ls");
            this.vrID = lrvrValue.get("vs");
        }
    }

    @Override
    public String toLogCommand(int messageID) throws NetconfException {
        StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append("<rpc message-id=\"");
        buf.append(messageID);
        buf.append("\"");
        if (null != this.rpcArgs) {
            Iterator<RpcArg> iter = this.rpcArgs.iterator();
            RpcArg arg = null;
            while (iter.hasNext()) {
                arg = iter.next();
                String key = arg.getName();
                String value = arg.getValue();
                buf.append(' ');
                buf.append(key);
                buf.append("=\"");
                buf.append(value);
                buf.append("\"");
            }
        }
        buf.append(" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        if (this.operationArg != null) {
            buf.append(this.operationArg.toLogCommand());
        }
        buf.append("</rpc>");
        return buf.toString();
    }
}

