/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.Filter;
import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;

public class PreviewArg
extends OperationArg {
    private FilterType filter;

    @Deprecated
    public PreviewArg(Filter filter) {
        switch (filter.getFilType()) {
            case 1: {
                this.filter = FilterType.SUBTREE;
                break;
            }
            case 2: {
                this.filter = FilterType.XPATH;
                break;
            }
            case 3: {
                this.filter = FilterType.OTHERS;
                break;
            }
        }
    }

    public PreviewArg(FilterType filter) throws NetconfException {
        this.filter = filter;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return this.filter != FilterType.XPATH || (0x100 & deviceCapability) != 0;
    }

    public FilterType getFilterType() {
        return this.filter;
    }

    public void setFilterType(FilterType filter) {
        this.filter = filter;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<preview xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\">");
        if (FilterType.SUBTREE == this.filter) {
            buf.append("<filter type=\"subtree\">");
            buf.append(this.getContent());
            buf.append("</filter>");
        } else if (FilterType.XPATH == this.filter) {
            buf.append("<filter type=\"xpath\" select=\"");
            buf.append(this.getContent());
            buf.append("\"/>");
        }
        buf.append("</preview>");
        return buf.toString();
    }

    @Override
    public String toLogCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<preview xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\">");
        if (FilterType.SUBTREE == this.filter) {
            buf.append("<filter type=\"subtree\">");
            buf.append(this.getLogContent());
            buf.append("</filter>");
        } else if (FilterType.XPATH == this.filter) {
            buf.append("<filter type=\"xpath\" select=\"");
            buf.append(this.getLogContent());
            buf.append("\"/>");
        }
        buf.append("</preview>");
        return buf.toString();
    }
}

