/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.error.NetconfException;

public abstract class OperationArg {
    protected static final String NS = "http://www.huawei.com/netconf/capability/base/1.0";
    protected String content;
    protected boolean keepAlive;
    protected String logContent;

    public OperationArg() {
    }

    public OperationArg(String content, String logContent) {
        this.content = content;
        this.logContent = logContent;
    }

    public boolean capable(int deviceCapability) {
        return (1 & deviceCapability) != 0;
    }

    public String getContent() {
        return this.content;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public boolean isKeepAlive() {
        return true;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setLogContent(String logContent) {
        this.logContent = logContent;
    }

    public abstract String toCommand() throws NetconfException;

    public String toLogCommand() throws NetconfException {
        return this.toCommand();
    }

    protected String getEmptyNodeStrWithNs(String nodeName) {
        return "<" + nodeName + " xmlns=\"" + NS + "\"/>";
    }

    protected String getNodeStartStrWithNs(String nodeName) {
        return "<" + nodeName + " xmlns=\"" + NS + "\">";
    }
}

