/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;

public class GetNextArg
extends OperationArg {
    private boolean discard;
    private int setID;

    public GetNextArg(boolean discard, int setID) throws NetconfException {
        this.discard = discard;
        this.setID = setID;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return (0x1000 & deviceCapability) != 0;
    }

    public int getSetID() {
        return this.setID;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public void setSetID(int setID) {
        this.setID = setID;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<get-next xmlns=\"");
        buf.append("http://www.huawei.com/netconf/capability/base/1.0");
        buf.append("\" set-id=\"");
        buf.append(this.setID);
        buf.append("\">");
        if (this.discard) {
            buf.append("<discard/>");
        }
        buf.append("</get-next>");
        return buf.toString();
    }
}

