/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.Filter;
import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.TargetType;

public class GetConfigArg
extends OperationArg {
    private FilterType filter;
    private TargetType sourceType;

    @Deprecated
    public GetConfigArg(Filter filter, int dbType) throws NetconfException {
        switch (filter.getFilType()) {
            case 1: {
                this.filter = FilterType.SUBTREE;
                break;
            }
            case 2: {
                this.filter = FilterType.XPATH;
                break;
            }
            case 3: {
                this.filter = FilterType.OTHERS;
                break;
            }
        }
        switch (dbType) {
            case 2: {
                this.sourceType = TargetType.CDB;
                break;
            }
            case 5: {
                this.sourceType = TargetType.CHECKPOINT;
                break;
            }
            case 1: {
                this.sourceType = TargetType.RDB;
                break;
            }
            case 3: {
                this.sourceType = TargetType.STARTUP;
                break;
            }
        }
    }

    public GetConfigArg(FilterType filter, TargetType target) throws NetconfException {
        this.filter = filter;
        this.sourceType = target;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if (this.filter == FilterType.XPATH && (0x100 & deviceCapability) == 0) {
            return false;
        }
        if (this.sourceType == TargetType.CDB && (4 & deviceCapability) == 0) {
            return false;
        }
        return this.sourceType != TargetType.STARTUP || (0x40 & deviceCapability) != 0;
    }

    public FilterType getFilterType() {
        return this.filter;
    }

    public TargetType getSourceType() {
        return this.sourceType;
    }

    public void setFilterType(FilterType filter) {
        this.filter = filter;
    }

    public void setSourceType(TargetType sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuffer buf = new StringBuffer("<get-config>");
        if (TargetType.RDB == this.sourceType) {
            buf.append("<source><running/></source>");
        } else if (TargetType.CDB == this.sourceType) {
            buf.append("<source><candidate/></source>");
        } else if (TargetType.STARTUP == this.sourceType) {
            buf.append("<source><startup/></source>");
        }
        if (this.filter == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">");
            buf.append(this.getContent());
            buf.append("</filter>");
        } else if (this.filter == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"");
            buf.append(this.getContent());
            buf.append("\"/>");
        }
        buf.append("</get-config>");
        return buf.toString();
    }

    @Override
    public String toLogCommand() throws NetconfException {
        StringBuffer buf = new StringBuffer("<get-config>");
        if (TargetType.RDB == this.sourceType) {
            buf.append("<source><running/></source>");
        } else if (TargetType.CDB == this.sourceType) {
            buf.append("<source><candidate/></source>");
        } else if (TargetType.STARTUP == this.sourceType) {
            buf.append("<source><startup/></source>");
        }
        if (this.filter == FilterType.SUBTREE) {
            buf.append("<filter type=\"subtree\">");
            buf.append(this.getLogContent());
            buf.append("</filter>");
        } else if (this.filter == FilterType.XPATH) {
            buf.append("<filter type=\"xpath\" select=\"");
            buf.append(this.getLogContent());
            buf.append("\"/>");
        }
        buf.append("</get-config>");
        return buf.toString();
    }
}

