/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.ErrorOperationType;
import com.huawei.vmf.netconf.service.OperationType;
import com.huawei.vmf.netconf.service.TargetType;
import com.huawei.vmf.netconf.service.TestOperationType;
import com.huawei.vmf.netconf.session.NetconfAbility;

public class EditConfigArg
extends OperationArg {
    private OperationType defaultOperation;
    private ErrorOperationType errorOperation;
    private TargetType targetCfgType;
    private TestOperationType testOperation;
    private String url;

    @Deprecated
    public EditConfigArg() {
    }

    public EditConfigArg(String url, ErrorOperationType errorOperation, TestOperationType testOperation) throws NetconfException {
        this.defaultOperation = OperationType.NONE;
        this.targetCfgType = TargetType.URL;
        this.url = url;
        this.errorOperation = errorOperation;
        this.testOperation = testOperation;
    }

    public EditConfigArg(String url, OperationType defaultOperation, ErrorOperationType errorOperation, TestOperationType testOperation) throws NetconfException {
        this.targetCfgType = TargetType.URL;
        this.url = url;
        this.defaultOperation = defaultOperation;
        this.errorOperation = errorOperation;
        this.testOperation = testOperation;
    }

    public EditConfigArg(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    public EditConfigArg(TargetType targetCfgType, ErrorOperationType errorOperation, TestOperationType testOperation) throws NetconfException {
        this(targetCfgType, OperationType.NONE, errorOperation, testOperation);
    }

    public EditConfigArg(TargetType targetCfgType, OperationType defaultOperation, ErrorOperationType errorOperation, TestOperationType testOperation) throws NetconfException {
        this(targetCfgType, null, defaultOperation, errorOperation, testOperation);
    }

    public EditConfigArg(TargetType targetCfgType, String url, OperationType defaultOperation, ErrorOperationType errorOperation, TestOperationType testOperation) {
        this.targetCfgType = targetCfgType;
        this.url = url;
        this.defaultOperation = defaultOperation;
        this.errorOperation = errorOperation;
        this.testOperation = testOperation;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return NetconfAbility.capable(this.targetCfgType, deviceCapability);
    }

    public OperationType getDefaultOperation() {
        return this.defaultOperation;
    }

    public ErrorOperationType getErrorOperation() {
        return this.errorOperation;
    }

    public TargetType getTargetCfgType() {
        return this.targetCfgType;
    }

    public TestOperationType getTestOperation() {
        return this.testOperation;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDefaultOperation(OperationType defaultOperation) {
        this.defaultOperation = defaultOperation;
    }

    public void setErrorOperation(ErrorOperationType errorOperation) {
        this.errorOperation = errorOperation;
    }

    public void setTargetCfgType(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    public void setTestOperation(TestOperationType testOperation) {
        this.testOperation = testOperation;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toCommand() throws NetconfException {
        if (this.content == null || "".equals(this.content)) {
            throw new NetconfException(-1, "edit-config must have config content.");
        }
        StringBuilder buf = new StringBuilder("<edit-config>");
        buf.append(this.targetCfgType.targetCommand(this.url, "target"));
        this.defaultOperation(buf);
        this.testOpinion(buf);
        this.contentOperation(buf);
        buf.append("</edit-config>");
        return buf.toString();
    }

    @Override
    public String toLogCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder("<edit-config>");
        buf.append(this.targetCfgType.targetCommand(this.url, "target"));
        this.defaultOperation(buf);
        this.testOpinion(buf);
        buf.append("<config>");
        buf.append(this.logContent);
        buf.append("</config>");
        buf.append("</edit-config>");
        return buf.toString();
    }

    private void contentOperation(StringBuilder buf) {
        buf.append("<config>");
        buf.append(this.content);
        buf.append("</config>");
    }

    private void defaultOperation(StringBuilder buf) {
        buf.append("<default-operation>");
        if (this.defaultOperation == OperationType.MERGE) {
            buf.append("merge");
        } else if (this.defaultOperation == OperationType.NONE) {
            buf.append("none");
        } else if (this.defaultOperation == OperationType.REPLACE) {
            buf.append("replace");
        }
        buf.append("</default-operation>");
    }

    private void testOpinion(StringBuilder buf) {
        buf.append("<error-option>");
        if (this.errorOperation == ErrorOperationType.ROLLBACK_ON_ERROR) {
            buf.append("rollback-on-error");
        } else if (this.errorOperation == ErrorOperationType.CONTINUE_ON_ERROR) {
            buf.append("continue-on-error");
        } else if (this.errorOperation == ErrorOperationType.STOP_ON_ERROR) {
            buf.append("stop-on-error");
        }
        buf.append("</error-option>");
    }
}

