/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.TargetType;

public class DeleteConfigArg
extends OperationArg {
    private TargetType targetCfgType = TargetType.URL;
    private String targetUrl;

    public DeleteConfigArg(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public TargetType getTargetCfgType() {
        return this.targetCfgType;
    }

    public void setTargetCfgType(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        return this.targetCfgType != TargetType.URL || (0x80 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuffer buf = new StringBuffer("<delete-config><target>");
        if (this.targetCfgType == TargetType.URL) {
            buf.append("<url>");
            buf.append(this.targetUrl);
            buf.append("</url>");
        } else if (this.targetCfgType == TargetType.STARTUP) {
            buf.append("<startup />");
        }
        buf.append("</target></delete-config>");
        return buf.toString();
    }
}

