/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.TargetType;

public class CopyConfigArg
extends OperationArg {
    private TargetType sourceCfgType;
    private String sourceUrl;
    private TargetType targetCfgType;
    private String targetUrl;

    public CopyConfigArg(String sourceUrl, String targetUrl) throws NetconfException {
        this.targetCfgType = TargetType.URL;
        this.sourceCfgType = TargetType.URL;
        this.sourceUrl = sourceUrl;
        this.targetUrl = targetUrl;
    }

    public CopyConfigArg(TargetType sourceCfgType, String targetUrl) throws NetconfException {
        this.sourceCfgType = sourceCfgType;
        this.targetUrl = targetUrl;
        this.targetCfgType = TargetType.URL;
    }

    public CopyConfigArg(String sourceUrl, TargetType targetCfgType) throws NetconfException {
        this.sourceUrl = sourceUrl;
        this.sourceCfgType = TargetType.URL;
        this.targetCfgType = targetCfgType;
    }

    public CopyConfigArg(TargetType sourceCfgType, TargetType targetCfgType) throws NetconfException {
        this.sourceCfgType = sourceCfgType;
        this.targetCfgType = targetCfgType;
    }

    public TargetType getSourceCfgType() {
        return this.sourceCfgType;
    }

    public void setSourceCfgType(TargetType sourceCfgType) {
        this.sourceCfgType = sourceCfgType;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public TargetType getTargetCfgType() {
        return this.targetCfgType;
    }

    public void setTargetCfgType(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((0x200 & deviceCapability) == 0) {
            return false;
        }
        if (this.targetCfgType == TargetType.CDB && (4 & deviceCapability) == 0) {
            return false;
        }
        if (this.targetCfgType == TargetType.RDB && (2 & deviceCapability) == 0) {
            return false;
        }
        return this.targetCfgType != TargetType.STARTUP || (0x40 & deviceCapability) != 0;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder buf = new StringBuilder();
        buf.append("<copy-config>");
        if (this.targetCfgType == TargetType.RDB) {
            buf.append("<target><running/></target>");
        } else if (this.targetCfgType == TargetType.CDB) {
            buf.append("<target><candidate/></target>");
        } else if (this.targetCfgType == TargetType.STARTUP) {
            buf.append("<target><startup/></target>");
        } else if (this.targetCfgType == TargetType.URL) {
            buf.append("<target><url>");
            buf.append(this.targetUrl);
            buf.append("</url></target>");
        } else if (this.targetCfgType == TargetType.CHECKPOINT) {
            buf.append("<target><checkpoint>");
            buf.append(this.targetUrl);
            buf.append("</checkpoint></target>");
        }
        if (this.sourceCfgType == TargetType.RDB) {
            buf.append("<source><running/></source>");
        } else if (this.sourceCfgType == TargetType.CDB) {
            buf.append("<source><candidate/></source>");
        } else if (this.sourceCfgType == TargetType.STARTUP) {
            buf.append("<source><startup/></source>");
        } else if (this.sourceCfgType == TargetType.URL) {
            buf.append("<source><url>");
            buf.append(this.sourceUrl);
            buf.append("</url></source>");
        } else if (this.sourceCfgType == TargetType.CHECKPOINT) {
            buf.append("<source><checkpoint>");
            buf.append(this.sourceUrl);
            buf.append("</checkpoint></source>");
        }
        buf.append("</copy-config>");
        return buf.toString();
    }
}

