/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.TargetType;
import com.huawei.vmf.netconf.session.NetconfAbility;

public class CompareConfigArg
extends OperationArg {
    private TargetType sourceCfgType;
    private String sourceCfgContent;
    private TargetType targetCfgType;
    private String targetCfgContent;

    public CompareConfigArg(TargetType sourceCfgType, String sourceCfgContent, TargetType targetCfgType, String targetCfgContent) throws NetconfException {
        this.sourceCfgType = sourceCfgType;
        this.sourceCfgContent = sourceCfgContent;
        this.targetCfgType = targetCfgType;
        this.targetCfgContent = targetCfgContent;
    }

    public CompareConfigArg(TargetType sourceCfgType, String sourceCfgContent, TargetType targetCfgType) {
        this.sourceCfgType = sourceCfgType;
        this.sourceCfgContent = sourceCfgContent;
        this.targetCfgType = targetCfgType;
    }

    public CompareConfigArg(TargetType sourceCfgType, TargetType targetCfgType, String targetCfgContent) {
        this.sourceCfgType = sourceCfgType;
        this.targetCfgType = targetCfgType;
        this.targetCfgContent = targetCfgContent;
    }

    public CompareConfigArg(TargetType sourceCfgType, TargetType targetCfgType) {
        this.sourceCfgType = sourceCfgType;
        this.targetCfgType = targetCfgType;
    }

    public CompareConfigArg() {
        this.sourceCfgType = TargetType.RDB;
        this.targetCfgType = TargetType.CDB;
    }

    public TargetType getSourceCfgType() {
        return this.sourceCfgType;
    }

    public void setSourceCfgType(TargetType sourceCfgType) {
        this.sourceCfgType = sourceCfgType;
    }

    public String getSourceCfgContent() {
        return this.sourceCfgContent;
    }

    public void setSourceCfgContent(String sourceCfgContent) {
        this.sourceCfgContent = sourceCfgContent;
    }

    public TargetType getTargetCfgType() {
        return this.targetCfgType;
    }

    public void setTargetCfgType(TargetType targetCfgType) {
        this.targetCfgType = targetCfgType;
    }

    public String getTargetCfgContent() {
        return this.targetCfgContent;
    }

    public void setTargetCfgContent(String targetCfgContent) {
        this.targetCfgContent = targetCfgContent;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((0x200 & deviceCapability) == 0) {
            return false;
        }
        return NetconfAbility.capable(this.targetCfgType, deviceCapability) && NetconfAbility.capable(this.sourceCfgType, deviceCapability);
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder front = new StringBuilder();
        front.append("<compare-config xmlns=\"");
        front.append("http://www.huawei.com/netconf/capability/base/1.0");
        front.append("\">");
        front.append(this.targetCfgType.targetCommand(this.targetCfgContent, "target"));
        front.append(this.sourceCfgType.targetCommand(this.sourceCfgContent, "source"));
        front.append("</compare-config>");
        return front.toString();
    }
}

