/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;

public class CommunicateArg {
    public static final int PASSWD_AND_PUBLIC_KEY = 3;
    public static final int PASSWORD_AUTH = 1;
    public static final int PUBLIC_KEY_AUTH = 2;
    private static final long MIN_TIMEOUT_UNIT = 1000L;
    protected String ip;
    protected String key;
    protected String passwordPhrase;
    protected String userName;
    protected String password;
    protected int port;
    protected int type;
    protected long responseTimeout;
    protected long loginTimeout;
    protected String protocol;

    public static int getPasswordAndPublicKey() {
        return 3;
    }

    public static int getPasswordAuth() {
        return 1;
    }

    public static int getPublicKeyAuth() {
        return 2;
    }

    public CommunicateArg(String ip, String key, String passwordPhrase, int port, String userName) {
        this(ip, key, passwordPhrase, userName, null, port, 2, 0L, 0L);
    }

    public CommunicateArg(String ip, String username, String password, int port) {
        this(ip, null, null, username, password, port, 1, 0L, 0L);
    }

    public CommunicateArg(String ip, String key, String passwordPhrase, String username, String password, int port) throws NetconfException {
        this(ip, key, passwordPhrase, username, password, port, 3, 0L, 0L);
    }

    public CommunicateArg(String ip, String key, String passwordPhrase, String username, String password, int port, int type, long responseTimeout, long loginTimeout) {
        this.ip = ip;
        this.key = CommunicateArg.remedyPrivateKeyContent(key);
        this.passwordPhrase = passwordPhrase;
        this.userName = username;
        this.password = password;
        this.port = port;
        this.type = type;
        this.responseTimeout = CommunicateArg.reviseTimeOut(responseTimeout, Netconf.getDefaultResponseTimeout());
        this.loginTimeout = CommunicateArg.reviseTimeOut(loginTimeout, Netconf.getDefaultLoginTimeout());
    }

    public String getIp() {
        return this.ip;
    }

    public String getKey() {
        if (this.key == null) {
            return "";
        }
        return this.key;
    }

    private static String remedyPrivateKeyContent(String key) {
        if (key == null) {
            return "";
        }
        String result = key.trim();
        if (!result.contains("-----BEGIN RSA PRIVATE KEY-----\n") && !result.contains("-----BEGIN RSA PRIVATE KEY-----\r\n")) {
            result = result.replaceFirst("-----BEGIN RSA PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----\n");
        }
        if (!result.contains("\n-----END RSA PRIVATE KEY-----") && !result.contains("\r\n-----END RSA PRIVATE KEY-----")) {
            result = result.replace("-----END RSA PRIVATE KEY-----", "\n-----END RSA PRIVATE KEY-----");
        }
        return result;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public String getPasswordPhrase() {
        if (this.passwordPhrase == null) {
            return "";
        }
        return this.passwordPhrase;
    }

    public int getPort() {
        return this.port;
    }

    public int getType() {
        return this.type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setKey(String key) {
        this.key = CommunicateArg.remedyPrivateKeyContent(key);
    }

    public void setPasswordPhrase(String passwordPhrase) {
        this.passwordPhrase = passwordPhrase;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = CommunicateArg.reviseTimeOut(responseTimeout, Netconf.getDefaultResponseTimeout());
    }

    public long getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(long loginTimeout) {
        this.loginTimeout = CommunicateArg.reviseTimeOut(loginTimeout, Netconf.getDefaultLoginTimeout());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUserName() {
        if (this.userName == null) {
            return "";
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private static long reviseTimeOut(long timeout, long defaultTimeout) {
        long ret = timeout;
        if (ret <= 0L) {
            ret = defaultTimeout;
        } else if (ret < 1000L) {
            ret = timeout * 1000L;
        }
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CommunicateArg{ip=").append(this.ip);
        builder.append(", username=").append(this.userName);
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicateArg)) {
            return false;
        }
        CommunicateArg other = (CommunicateArg)obj;
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }
}

