/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.datadefination;

import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.error.NetconfException;
import org.apache.commons.lang.StringUtils;

public class CommitArg
extends OperationArg {
    private static final int MAX_DESCRIPTION_LENGTH = 60;
    private static final String OMITTED_VALUE = "...";
    private boolean confirmed;
    private long confirmTimeout = -1L;
    private String description;

    public CommitArg() {
    }

    public CommitArg(long confirmTimeout, boolean confirmed) throws NetconfException {
        if (confirmTimeout <= 0L) {
            throw new NetconfException(-1);
        }
        this.confirmed = confirmed;
        this.confirmTimeout = confirmTimeout;
    }

    @Override
    public boolean capable(int deviceCapability) {
        if (!super.capable(deviceCapability)) {
            return false;
        }
        if ((4 & deviceCapability) == 0) {
            return false;
        }
        return !this.confirmed || (8 & deviceCapability) != 0;
    }

    public long getConfirmtimeout() {
        return this.confirmTimeout;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public boolean isKeepAlive() {
        return true;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setConfirmtimeout(long confirmTimeout) {
        this.confirmTimeout = confirmTimeout;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toCommand() throws NetconfException {
        StringBuilder builder = new StringBuilder("<commit>");
        if (!StringUtils.isEmpty((String)this.description)) {
            builder.append(this.getNodeStartStrWithNs("description"));
            builder.append(this.regularDescription());
            builder.append("</description>");
        }
        builder.append(this.getEmptyNodeStrWithNs("update-candidate"));
        if ("<commit>".length() == builder.toString().length()) {
            return "<commit/>";
        }
        builder.append("</commit>");
        return builder.toString();
    }

    private String regularDescription() {
        String tmpDescription = this.description;
        tmpDescription = tmpDescription.replaceAll("&", "&amp;");
        tmpDescription = tmpDescription.replaceAll("<", "&lt;");
        tmpDescription = tmpDescription.replaceAll(">", "&gt;");
        tmpDescription = tmpDescription.replaceAll("\"", "&quot;");
        if ((tmpDescription = tmpDescription.replaceAll("'", "&apos;")).length() <= 60) {
            return tmpDescription;
        }
        int lastDollarIndex = (tmpDescription = tmpDescription.substring(0, 60 - OMITTED_VALUE.length())).lastIndexOf(38);
        if (lastDollarIndex > tmpDescription.lastIndexOf(59)) {
            tmpDescription = tmpDescription.substring(0, lastDollarIndex);
        }
        return tmpDescription + OMITTED_VALUE;
    }
}

