/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnNeNetConfPara;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnSetNeNetConfParaReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnSetNeNetConfParaRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.task.IQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.netconf.para.service.impl.NetconfCommHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SetNeNetConfParaTask
implements IQTask<QAsnSetNeNetConfParaReq, QAsnSetNeNetConfParaRsp> {
    private static final String EMPTY_PRIVATE_KEY = " ";
    private static Logger logger = LoggerFactory.getLogger(SetNeNetConfParaTask.class);
    private static NetconfCommHandler netConfHandler = new NetconfCommHandler();
    private static Set<String> netconfParaNoKeyAttrNames = new LinkedHashSet<String>();

    public void execute(QAsnSetNeNetConfParaReq req, QAsnSetNeNetConfParaRsp rsp, Task task) {
        rsp.result.result = 1107498880;
        List<NetConfPara> netconfParas = null;
        try {
            Context context = new Context();
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
            netconfParas = this.decode(req);
            if (CollectionUtils.isEmpty(netconfParas)) {
                logger.info("createNetconfParas is empty.");
                rsp.result.result = 0;
                return;
            }
            Collection tmpExistNetconfParas = dao.queryByKey(NetConfPara.class, netconfParas, false);
            HashSet existNetconfParas = new HashSet();
            if (!CollectionUtils.isEmpty((Collection)tmpExistNetconfParas)) {
                existNetconfParas.addAll(tmpExistNetconfParas);
            }
            IMOChangeRecord moChangeRecord = context.addChangeRecord(NetConfPara.class);
            for (NetConfPara netconfPara : netconfParas) {
                if (existNetconfParas.contains(netconfPara)) {
                    moChangeRecord.addModify((Object)netconfPara, netconfParaNoKeyAttrNames);
                    continue;
                }
                moChangeRecord.addCreate((Object)netconfPara);
            }
            dao.merge(NetConfPara.class, false);
            boolean success = true;
            int failNum = 0;
            for (NetConfPara netconfPara : netconfParas) {
                int result = netConfHandler.createSessionPool(netconfPara.getDevIP(), netconfPara);
                if (0 == result) continue;
                ++failNum;
                success = false;
                this.addErrorInfo(rsp.result, netconfPara, result, null);
            }
            rsp.result.result = success ? 0 : (failNum == netconfParas.size() ? 1107499878 : 1107499879);
        }
        catch (VMFException e) {
            logger.error("setNeNetConfParaTask VMFException.", (Throwable)e);
            this.setErrorResults(rsp, netconfParas, e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception e) {
            logger.error("setNeNetConfParaTask Exception.", (Throwable)e);
            this.setErrorResults(rsp, netconfParas, 1107498880, null);
        }
    }

    private void addErrorInfo(QAsnErrInfoReturn errInfo, NetConfPara netconfPara, int errorCode, String errorMessage) {
        if (null == errInfo.errList) {
            errInfo.errList = new QAsnErrInfoList();
        }
        QAsnErrInfo errorInfo = new QAsnErrInfo();
        errorInfo.objID.add((Object)netconfPara.getDevID());
        errorInfo.objName = AsnUtil.getBytes((String)netconfPara.getDevIP());
        errorInfo.errCode = errorCode;
        errorInfo.strOperDesc = AsnUtil.getBytes((String)errorMessage);
        errInfo.errList.add((Object)errorInfo);
    }

    private List<NetConfPara> decode(QAsnSetNeNetConfParaReq req) {
        ArrayList<NetConfPara> netConfParas = new ArrayList<NetConfPara>();
        for (Object obj : req.lstNetConfPara) {
            QAsnNeNetConfPara asn = (QAsnNeNetConfPara)obj;
            NetConfPara netConfPara = new NetConfPara();
            netConfPara.setDevID(Integer.valueOf(asn.neID));
            netConfPara.setDevIP(StringUtil.globalString((byte[])asn.devIP));
            netConfPara.setAuthMode(Integer.valueOf(asn.authMode.intValue()));
            netConfPara.setLoginTimeout(Integer.valueOf(asn.loginTimeout.intValue()));
            netConfPara.setPort(Integer.valueOf(asn.port.intValue()));
            netConfPara.setResponseTimeout(Integer.valueOf(asn.responseTimeout.intValue()));
            netConfPara.setUserName(StringUtil.globalString((byte[])asn.userName));
            netConfPara.setPassword(com.huawei.vmf.common.tool.StringUtil.frame2PlatformEncode((byte[])asn.password));
            netConfPara.setPrivateKey(StringUtil.globalString((byte[])asn.privateKey));
            if (StringUtils.hasLength((String)netConfPara.getPrivateKey())) {
                netConfPara.setPasswordPhrase(com.huawei.vmf.common.tool.StringUtil.frame2PlatformEncode((byte[])asn.passwordPhrase));
            } else {
                netConfPara.setPrivateKey(EMPTY_PRIVATE_KEY);
                netConfPara.setPasswordPhrase("");
            }
            logger.info("QAsnNeNetConfPara={}", (Object)netConfPara);
            netConfParas.add(netConfPara);
        }
        return netConfParas;
    }

    private void setErrorResults(QAsnSetNeNetConfParaRsp rsp, List<NetConfPara> netconfParas, int errorCode, String errorMessage) {
        rsp.result.result = 1107499878;
        if (CollectionUtils.isEmpty(netconfParas)) {
            return;
        }
        rsp.result.errList = new QAsnErrInfoList();
        for (NetConfPara netconfPara : netconfParas) {
            this.addErrorInfo(rsp.result, netconfPara, errorCode, errorMessage);
        }
    }

    static {
        netconfParaNoKeyAttrNames.add("devIP");
        netconfParaNoKeyAttrNames.add("userName");
        netconfParaNoKeyAttrNames.add("password");
        netconfParaNoKeyAttrNames.add("port");
        netconfParaNoKeyAttrNames.add("privateKey");
        netconfParaNoKeyAttrNames.add("passwordPhrase");
        netconfParaNoKeyAttrNames.add("authMode");
        netconfParaNoKeyAttrNames.add("loginTimeout");
        netconfParaNoKeyAttrNames.add("responseTimeout");
    }
}

