/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_netconf_dc.QAsnGetNetConfReq;
import com.huawei.network.qasn.m_q_ip_netconf_dc.QAsnGetNetConfRsp;
import com.huawei.network.qasn.m_q_ip_netconf_dc.QAsnNeNetConfPara;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.IQTask;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.common.tool.FrameCihperTool;
import com.huawei.vmf.common.tool.PlatformCipherTool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNetConfParaTask
implements IQTask<QAsnGetNetConfReq, QAsnGetNetConfRsp> {
    private static Logger logger = LoggerFactory.getLogger(GetNetConfParaTask.class);

    public void execute(QAsnGetNetConfReq req, QAsnGetNetConfRsp rsp, Task task) {
        ArrayList<Integer> devIDs = new ArrayList<Integer>();
        try {
            for (Object obj : req.lstDevID) {
                devIDs.add((int)((Integer)obj));
            }
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            Collection netconfParas = dao.queryByNeID(NetConfPara.class, devIDs, false);
            block3: for (Integer devID : devIDs) {
                for (NetConfPara para : netconfParas) {
                    if (!devID.equals(para.getDevID())) continue;
                    rsp.lstResult.add((Object)this.encodeQAsnNeNetConfPara(para, 0));
                    continue block3;
                }
            }
        }
        catch (VMFException e) {
            logger.error("Error occurs getNetconfParaInfo fail", (Throwable)e);
            this.setErrorResults(devIDs, e.getErrorCode());
            return;
        }
    }

    private void setErrorResults(List<Integer> devIDs, int errorCode) {
        for (Integer devID : devIDs) {
            NetConfPara netConfPara = new NetConfPara();
            netConfPara.setDevID(devID);
            this.encodeQAsnNeNetConfPara(netConfPara, errorCode);
        }
    }

    public QAsnNeNetConfPara encodeQAsnNeNetConfPara(NetConfPara netConfPara, int errorCode) {
        QAsnNeNetConfPara asn = new QAsnNeNetConfPara();
        AsnUtil.setDefaultAsnValue((FStruct)asn);
        asn.devIP = StringUtil.globalByte((String)netConfPara.getDevIP());
        asn.devID = netConfPara.getDevID();
        asn.authMode = BigInteger.valueOf(netConfPara.getAuthMode().intValue());
        asn.loginTimeout = BigInteger.valueOf(netConfPara.getLoginTimeout().intValue());
        asn.responseTimeout = BigInteger.valueOf(netConfPara.getResponseTimeout().intValue());
        byte[] tmpPassword = PlatformCipherTool.decrypt((String)netConfPara.getPassword());
        byte[] frameEnPassword = FrameCihperTool.encrypt((byte[])tmpPassword);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPassword);
        asn.password = frameEnPassword;
        asn.userName = StringUtil.globalByte((String)netConfPara.getUserName());
        asn.port = BigInteger.valueOf(netConfPara.getPort().intValue());
        asn.privateKey = StringUtil.globalByte((String)netConfPara.getPrivateKey());
        byte[] tmpPasswordPhrase = PlatformCipherTool.decrypt((String)netConfPara.getPasswordPhrase());
        byte[] frameEnPasswordPhrase = FrameCihperTool.encrypt((byte[])tmpPasswordPhrase);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPasswordPhrase);
        asn.passwordPhrase = frameEnPasswordPhrase;
        asn.errorCode = BigInteger.valueOf(errorCode);
        return asn;
    }
}

