/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.WriteLog;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.common.mediation.AdapterInfo;
import com.huawei.vmf.nemgr.asn.netconf.AsnResult;
import com.huawei.vmf.nemgr.asn.netconf.AsnTestParaReq;
import com.huawei.vmf.netconf.para.Activator;
import com.huawei.vmf.netconf.para.asn.translator.NetConfParaTranslator;
import com.huawei.vmf.netconf.para.internal.TestNetconfParaIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import com.huawei.vmf.netconf.para.service.impl.NetconfCommHandler;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNetconfParaImpl
extends AbstractNetConfParaOper
implements TestNetconfParaIF {
    private static final Logger log = LoggerFactory.getLogger(TestNetconfParaImpl.class);
    private static final String UNKNOWN = "unknown";
    private NetconfCommHandler netConfHandler = null;

    public NetconfCommHandler getNetConfHandler() {
        if (this.netConfHandler == null) {
            this.netConfHandler = new NetconfCommHandler();
        }
        return this.netConfHandler;
    }

    public void setNetConfHandler(NetconfCommHandler netConfHandler) {
        this.netConfHandler = netConfHandler;
    }

    @Override
    public void testNetconfPara(AsnTestParaReq req, AsnResult rsp, MSGHead head) {
        int devID = 0;
        int userID = 0;
        boolean isV5V8Test = false;
        if (req.iV5V8TestLogo != null && req.iV5V8TestLogo.intValue() == 1) {
            isV5V8Test = true;
        }
        NetConfPara netconfpara = null;
        try {
            devID = req.iDevID.intValue();
            userID = req.iUserID.intValue();
            netconfpara = NetConfParaTranslator.decodeAsnNetconfBasePara(req.oNetconfBasePara);
        }
        catch (Exception e) {
            log.error("req is not valid", (Throwable)e);
            rsp.iCode = BigInteger.valueOf(1107498874L);
            return;
        }
        int result = 0;
        int cmdID = head.cmdCode;
        Long ipAddr = head.senderProcIP;
        String operateDesc = null;
        String IP = new String(req.strDevIP);
        String label = null;
        try {
            label = Activator.getDeviceService().getDevNameByID(devID);
            if (IP.equals(UNKNOWN)) {
                IP = Activator.getDeviceService().getDevIPByID(devID);
            }
            operateDesc = WriteLog.getString((String)"devname") + label + "," + WriteLog.getString((String)"devip") + IP;
        }
        catch (VMFException e) {
            log.error("queryDevIPbyDevID fail", (Throwable)e);
            rsp.iCode = BigInteger.valueOf(e.getErrorCode());
            result = 2;
            this.writeDeviceOperLog(userID, cmdID, e.getErrorCode(), result, ipAddr, null);
            return;
        }
        AdapterInfo adapterInfo = new AdapterInfo(devID);
        List infos = Activator.getMessageTempletService().getSessionCheckMessages(adapterInfo);
        int ireturn = 0;
        ireturn = isV5V8Test ? this.getNetConfHandler().testPoolCommunicateV5V8(IP, netconfpara, infos) : this.getNetConfHandler().testPoolCommunicate(IP, netconfpara, infos);
        if (0 != ireturn) {
            log.error("test NETCONFPara fail");
            rsp.iCode = BigInteger.valueOf(ireturn);
            result = 2;
            this.writeDeviceOperLog(userID, cmdID, ireturn, result, ipAddr, operateDesc);
            return;
        }
        rsp.iCode = BigInteger.valueOf(0L);
        result = 0;
        this.writeDeviceOperLog(userID, cmdID, ireturn, result, ipAddr, operateDesc);
    }
}

