/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventManager;
import com.huawei.uflight.event.client.MapEvent;
import com.huawei.uflight.event.client.ObjectEvent;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.common.utilty.WriteLog;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.common.mediation.AdapterInfo;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfResultForMutil;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfResultListForMutil;
import com.huawei.vmf.nemgr.asn.netconf.AsnNetconfReqForMutil;
import com.huawei.vmf.netconf.para.Activator;
import com.huawei.vmf.netconf.para.asn.translator.NetConfParaTranslator;
import com.huawei.vmf.netconf.para.internal.SetNetconfParaIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import com.huawei.vmf.netconf.para.service.impl.NetconfCommHandler;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetNetconfParaImpl
extends AbstractNetConfParaOper
implements SetNetconfParaIF {
    public static final String NETCONF_PARA_SUCCESS_PANEL = "com/huawei/vmf/nemgr/devmgr/devimpl/SetNetconfParaImpl/NETCONFEVENT/PANEL";
    private static final Logger log = LoggerFactory.getLogger(SetNetconfParaImpl.class);
    private static List<String> netconfParaModifyAttrs = new ArrayList<String>();
    private NetconfCommHandler netConfHandler = null;

    public NetconfCommHandler getNetConfHandler() {
        if (null == this.netConfHandler) {
            this.netConfHandler = new NetconfCommHandler();
        }
        return this.netConfHandler;
    }

    @Override
    public void setNetconfPara(AsnNetconfReqForMutil req, AsnConfNetconfResultListForMutil rspLst, MSGHead head) {
        NetConfPara netconfpara = NetConfParaTranslator.decodeAsnNetconfBasePara(req.oNetconfBasePara);
        ArrayList<Integer> devIDs = new ArrayList<Integer>(req.objList.size());
        for (int i = 0; i < req.objList.size(); ++i) {
            devIDs.add(((BigInteger)req.objList.get(i)).intValue());
        }
        try {
            this.modifyParam(netconfpara, devIDs, req, head, rspLst);
        }
        catch (VMFException e) {
            log.error("Error occurs when setNetconfPara.", (Throwable)e);
            for (Integer devID : devIDs) {
                AsnConfNetconfResultForMutil rspTmp = new AsnConfNetconfResultForMutil();
                this.addRspLst(e.getErrorCode(), devID, rspTmp, rspLst);
            }
        }
    }

    @Override
    public int setNetconfParaForTrans(String ip, NetConfPara para) {
        int result = this.getNetConfHandler().createSessionPool(ip, para);
        log.info("getNetconfhandler().createSessionPool " + result);
        if (0 == result) {
            try {
                Integer devId = Activator.getDeviceService().getDevIDByIP(ip);
                AdapterInfo adapterInfo = new AdapterInfo(devId.intValue());
                List infos = Activator.getMessageTempletService().getSessionCheckMessages(adapterInfo);
                result = this.getNetConfHandler().testPoolCommunicate(ip, para, infos);
            }
            catch (VMFException e) {
                log.info("getNetconfhandler().testPoolCommunicate " + result);
            }
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(NetConfPara.class);
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
        if (0 == result) {
            NetConfPara temp = null;
            try {
                Collection paras = dao.queryByNeID(NetConfPara.class, Arrays.asList(para.getDevID()), false);
                NetConfPara netConfPara = temp = paras.isEmpty() ? null : (NetConfPara)paras.iterator().next();
                if (null == temp) {
                    record.addCreate((Object)para);
                } else {
                    record.addModify((Object)para, Arrays.asList("authMode", "loginTimeout", "password", "port", "privateKey", "responseTimeout", "userName"));
                }
                dao.merge(NetConfPara.class, false);
            }
            catch (VMFException e) {
                log.debug("get netconf para error!");
            }
        }
        return result;
    }

    private void addRspLst(int ret, int neID, AsnConfNetconfResultForMutil rspTmp, AsnConfNetconfResultListForMutil rspLst) {
        rspTmp.iCode = BigInteger.valueOf(ret);
        rspTmp.iDevID = BigInteger.valueOf(neID);
        rspLst.add((Object)rspTmp);
    }

    private void copy(NetConfPara destPara, NetConfPara srcPara) {
        destPara.setAuthMode(srcPara.getAuthMode());
        destPara.setLoginTimeout(srcPara.getLoginTimeout());
        destPara.setPassword(srcPara.getPassword());
        destPara.setPort(srcPara.getPort());
        destPara.setPrivateKey(srcPara.getPrivateKey());
        destPara.setResponseTimeout(srcPara.getResponseTimeout());
        destPara.setUserName(srcPara.getUserName());
        destPara.setPasswordPhrase(srcPara.getPasswordPhrase());
    }

    private void modifyParam(NetConfPara netconfpara, List<Integer> devIDs, AsnNetconfReqForMutil req, MSGHead head, AsnConfNetconfResultListForMutil rspLst) throws VMFException {
        AsnConfNetconfResultForMutil rspTmp;
        ArrayList<Pair<Integer, String>> modifiedDevs = new ArrayList<Pair<Integer, String>>();
        LinkedList<Integer> modifyDevIDs = new LinkedList<Integer>(devIDs);
        int result = 0;
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(NetConfPara.class);
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
        Collection paras = dao.queryByNeID(NetConfPara.class, devIDs, false);
        for (NetConfPara para : paras) {
            Integer devID = para.getDevID();
            modifyDevIDs.remove(devID);
            this.copy(para, netconfpara);
            record.addModify((Object)para, netconfParaModifyAttrs);
        }
        for (Integer devID : modifyDevIDs) {
            String ip = Activator.getDeviceService().getDevIPByID(devID.intValue());
            if (ip == null || "".equals(ip)) {
                result = 1107498867;
                rspTmp = new AsnConfNetconfResultForMutil();
                this.addRspLst(result, devID, rspTmp, rspLst);
                continue;
            }
            NetConfPara oldPara = new NetConfPara();
            oldPara.setDevID(devID);
            oldPara.setDevIP(ip);
            this.copy(oldPara, netconfpara);
            record.addCreate((Object)oldPara);
        }
        dao.merge(NetConfPara.class, false);
        for (NetConfPara para : record.getModifies()) {
            if (0 == result) {
                result = this.getNetConfHandler().modifySessionPool(para.getDevIP(), netconfpara);
            }
            AsnConfNetconfResultForMutil rspTmp2 = new AsnConfNetconfResultForMutil();
            String label = Activator.getDeviceService().getDevNameByID(para.getDevID().intValue());
            modifiedDevs.add((Pair<Integer, String>)new Pair((Object)para.getDevID(), (Object)para.getDevIP()));
            this.addRspLst(result, para.getDevID(), rspTmp2, rspLst);
            this.writeErrorLog(req, head, rspTmp2, label, para.getDevIP(), result);
        }
        for (NetConfPara para : record.getCreates()) {
            if (0 == result) {
                result = this.getNetConfHandler().createSessionPool(para.getDevIP(), netconfpara);
            }
            String label = Activator.getDeviceService().getDevNameByID(para.getDevID().intValue());
            rspTmp = new AsnConfNetconfResultForMutil();
            modifiedDevs.add((Pair<Integer, String>)new Pair((Object)para.getDevID(), (Object)para.getDevIP()));
            this.addRspLst(result, para.getDevID(), rspTmp, rspLst);
            this.writeErrorLog(req, head, rspTmp, label, para.getDevIP(), result);
        }
        this.sendEventForNetconf(modifiedDevs);
    }

    private void sendEventForNetconf(List<Pair<Integer, String>> modifiedDevs) {
        IEventManager eventManager = Activator.getEventManager();
        ArrayList modifiedIps = new ArrayList(modifiedDevs.size());
        if (null != eventManager) {
            log.info("setNetconfParaImpl eventManager is not null");
            try {
                for (Pair<Integer, String> pair : modifiedDevs) {
                    int devID = (Integer)pair.getKey();
                    eventManager.publishEvent((IEvent)new ObjectEvent("com.huawei.vmf.netconf.para.eventNETCONF_PARA_SUCCESS_DEVID", devID));
                    log.info("notify Event:[TOPIC={}, PARA={}]", new Object[]{"com.huawei.vmf.netconf.para.eventNETCONF_PARA_SUCCESS_DEVID", devID});
                }
                MapEvent event = new MapEvent("com.huawei.vmf.netconf.para.eventNETCONF_PARA_SUCCESS_DEVIP", 0);
                event.setObject("devIP", modifiedIps);
                eventManager.publishEvent((IEvent)event);
                log.info("notify Event:[TOPIC={}, PARA={}]", new Object[]{"com.huawei.vmf.netconf.para.eventNETCONF_PARA_SUCCESS_DEVIP", event});
            }
            catch (EventExcpetion e) {
                log.error("publishEvent failed.", (Throwable)e);
            }
            log.info("setNetconfParaImpl publishEvent panel success");
        } else {
            log.info("IEventManager service is not avaiable.");
        }
    }

    private void writeErrorLog(AsnNetconfReqForMutil req, MSGHead head, AsnConfNetconfResultForMutil rspTmp, String label, String ip, int result) {
        int userID = req.iUserID.intValue();
        int cmdID = head.cmdCode;
        Long ipAddr = head.senderProcIP;
        int result1 = result == 0 ? 0 : 2;
        StringBuffer operateDescFail = new StringBuffer();
        operateDescFail.append(WriteLog.getString((String)"devname")).append(label).append(",").append(WriteLog.getString((String)"devip")).append(ip);
        this.writeDeviceOperLog(userID, cmdID, result, result1, ipAddr, operateDescFail.toString());
    }

    static {
        netconfParaModifyAttrs.add("userName");
        netconfParaModifyAttrs.add("password");
        netconfParaModifyAttrs.add("port");
        netconfParaModifyAttrs.add("privateKey");
        netconfParaModifyAttrs.add("passwordPhrase");
        netconfParaModifyAttrs.add("authMode");
        netconfParaModifyAttrs.add("loginTimeout");
        netconfParaModifyAttrs.add("responseTimeout");
    }
}

