/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.nemgr.asn.netconf.AsnGetNetconfParaReq;
import com.huawei.vmf.nemgr.asn.netconf.AsnNetconfParaResp;
import com.huawei.vmf.netconf.para.asn.translator.NetConfParaTranslator;
import com.huawei.vmf.netconf.para.internal.QueryNetconfParaIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryNetconfParaImpl
extends AbstractNetConfParaOper
implements QueryNetconfParaIF {
    private static Logger logger = LoggerFactory.getLogger(QueryNetconfParaImpl.class);
    private static final int NOT_EXIST_PARA = -1;

    @Override
    public void queryNetconfPara(AsnGetNetconfParaReq req, AsnNetconfParaResp rsp, MSGHead head) {
        rsp.oResult.iCode = BigInteger.valueOf(0L);
        ArrayList<Integer> devIDs = new ArrayList<Integer>();
        try {
            for (Object obj : req.lstDevID) {
                devIDs.add(((BigInteger)obj).intValue());
            }
        }
        catch (Exception e) {
            logger.error("req is not valid");
            rsp.oResult.iCode = BigInteger.valueOf(1107498874L);
            return;
        }
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            Collection netconfParas = dao.queryByNeID(NetConfPara.class, devIDs, false);
            for (Integer devID : devIDs) {
                boolean find = false;
                for (NetConfPara para : netconfParas) {
                    if (!devID.equals(para.getDevID())) continue;
                    rsp.lstNetconfPara.add((Object)NetConfParaTranslator.encodeAsnNetconfBasePara(para));
                    find = true;
                    break;
                }
                if (find) continue;
                NetConfPara notExist = new NetConfPara();
                notExist.setDevID(devID);
                notExist.setAuthMode(Integer.valueOf(-1));
                rsp.lstNetconfPara.add((Object)NetConfParaTranslator.encodeAsnNetconfBasePara(notExist));
            }
        }
        catch (VMFException e) {
            logger.error("Error occurs queryNetconfParaInfo fail", (Throwable)e);
            rsp.oResult.iCode = BigInteger.valueOf(e.getErrorCode());
            return;
        }
    }
}

