/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.common.mediation.MessageTempletInfo;
import com.huawei.vmf.common.netconf.DefaultNetconfClientFactory;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.netconf.session.SessionPool;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCommHandler {
    private static final Logger log = LoggerFactory.getLogger(NetconfCommHandler.class);

    public int createSessionPool(String IP, NetConfPara netconfpara) {
        int result = 0;
        if (null == IP || null == netconfpara) {
            log.error("param is not valid");
            return 1107498880;
        }
        CommunicateArg communicateArg = this.getCommunicateArg(netconfpara, IP);
        try {
            CommunicationArgumentMgr.addCommunicateArg((CommunicateArg)communicateArg);
        }
        catch (NetconfException e) {
            result = e.getErrorCode();
        }
        return result;
    }

    public int modifySessionPool(String IP, NetConfPara netconfpara) {
        int result = 0;
        if (null == IP || null == netconfpara) {
            log.error("param is not valid");
            return 1107498879;
        }
        try {
            CommunicateArg communicateArg = CommunicationArgumentMgr.getCommunicateArg((String)IP);
            if (communicateArg == null) {
                communicateArg = this.getCommunicateArg(netconfpara, IP);
                CommunicationArgumentMgr.addCommunicateArg((CommunicateArg)communicateArg);
            } else {
                this.copy(communicateArg, netconfpara);
                CommunicationArgumentMgr.addCommunicateArg((CommunicateArg)communicateArg);
            }
            log.info("changed netconf para:{}", (Object)communicateArg);
        }
        catch (NetconfException e) {
            result = e.getErrorCode();
        }
        return result;
    }

    public int testPoolCommunicate(String ip, NetConfPara netconfPara, List<MessageTempletInfo> infos) {
        if (null == ip || null == netconfPara) {
            log.error("IP or netconfpara is null. ip=" + ip + ", netconfpara=" + netconfPara);
            return 1107498880;
        }
        return DefaultNetconfClientFactory.testConnective((String)ip, infos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testPoolCommunicateV5V8(String IP, NetConfPara netconfpara, List<MessageTempletInfo> infos) {
        try {
            CommunicationArgumentMgr.delCommunicateArg((String)IP);
            SessionPool.onNetconfParameterChanged((String)IP);
            int result = this.createSessionPool(IP, netconfpara);
            if (result != 0) {
                int n = result;
                return n;
            }
            int n = DefaultNetconfClientFactory.testConnective((String)IP, infos);
            return n;
        }
        finally {
            CommunicationArgumentMgr.delCommunicateArg((String)IP);
            SessionPool.onNetconfParameterChanged((String)IP);
        }
    }

    private void copy(CommunicateArg arg, NetConfPara netconfpara) {
        boolean refreshNetconfSession = !arg.getUserName().equals(netconfpara.getUserName());
        refreshNetconfSession |= netconfpara.getPort().intValue() != arg.getPort();
        refreshNetconfSession |= !netconfpara.getPassword().equals(arg.getPassword());
        refreshNetconfSession |= netconfpara.getAuthMode().intValue() != arg.getType();
        refreshNetconfSession |= !arg.getPassword().equals(netconfpara.getPassword());
        arg.setType(netconfpara.getAuthMode().intValue());
        arg.setUserName(netconfpara.getUserName());
        arg.setKey(netconfpara.getPrivateKey());
        arg.setPassword(netconfpara.getPassword());
        arg.setPort(netconfpara.getPort().intValue());
        arg.setPasswordPhrase(netconfpara.getPasswordPhrase());
        arg.setLoginTimeout((long)netconfpara.getLoginTimeout().intValue());
        arg.setResponseTimeout((long)netconfpara.getResponseTimeout().intValue());
        if (refreshNetconfSession) {
            this.refreshNetconfSession(arg.getIp());
        }
    }

    private CommunicateArg getCommunicateArg(NetConfPara netconfpara, String ip) {
        CommunicateArg communicateArg = null;
        switch (netconfpara.getAuthMode()) {
            case 1: {
                communicateArg = new CommunicateArg(ip, netconfpara.getUserName(), netconfpara.getPassword(), netconfpara.getPort().intValue());
                break;
            }
            case 2: {
                communicateArg = new CommunicateArg(ip, netconfpara.getPrivateKey(), netconfpara.getPasswordPhrase(), netconfpara.getPort().intValue(), netconfpara.getUserName());
                break;
            }
            case 3: {
                try {
                    communicateArg = new CommunicateArg(ip, netconfpara.getPrivateKey(), netconfpara.getPasswordPhrase(), netconfpara.getUserName(), netconfpara.getPassword(), netconfpara.getPort().intValue());
                }
                catch (NetconfException e) {
                    log.error("communicateArg fail", (Throwable)e);
                }
                break;
            }
        }
        communicateArg.setLoginTimeout((long)netconfpara.getLoginTimeout().intValue());
        communicateArg.setResponseTimeout((long)netconfpara.getResponseTimeout().intValue());
        return communicateArg;
    }

    private void refreshNetconfSession(String ip) {
        SessionPool.onNetconfParameterChanged((String)ip);
    }
}

