/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.uflight.event.client.EventExcpetion;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.IEventManager;
import com.huawei.uflight.event.client.ObjectEvent;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetconfTemplate;
import com.huawei.vmf.adapter.fservice.netconf.para.service.INetConfService;
import com.huawei.vmf.common.mediation.AdapterInfo;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.para.Activator;
import com.huawei.vmf.netconf.para.service.impl.NetconfCommHandler;
import com.huawei.vmf.netconf.para.service.impl.QueryNetconfParaImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetConfServiceImpl
implements INetConfService {
    private static final Logger log = LoggerFactory.getLogger(QueryNetconfParaImpl.class);
    private NetconfCommHandler netConfHandler;

    public NetConfServiceImpl() {
    }

    public NetConfServiceImpl(NetconfCommHandler netConfHandler) {
        this.netConfHandler = netConfHandler;
    }

    public int deleteNetConfPara(int devID) throws NetconfException {
        NetConfPara toBeDeleted = new NetConfPara();
        toBeDeleted.setDevID(Integer.valueOf(devID));
        Context ctx = new Context();
        ctx.addChangeRecord(NetConfPara.class).addDelete((Object)toBeDeleted);
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
            dao.merge(NetConfPara.class, false);
            return 0;
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public List<NetConfPara> getAllNetConfPara() throws NetconfException {
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            return (List)dao.queryAll(NetConfPara.class, false);
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public NetconfCommHandler getNetConfHandler() {
        return this.netConfHandler;
    }

    public List<NetConfPara> getNetConfPara(List<Integer> devIDs) throws NetconfException {
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            return (List)dao.queryByNeID(NetConfPara.class, devIDs, false);
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public NetConfPara getNetConfParaByID(int devID) throws NetconfException {
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            Collection paras = dao.queryByNeID(NetConfPara.class, Arrays.asList(devID), false);
            return paras.isEmpty() ? null : (NetConfPara)paras.iterator().next();
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public int modifyNetconfUserPWD(int neID, String userName, String pwd, boolean isOffLine) throws VMFException {
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(NetConfPara.class);
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
        Collection paras = dao.queryByNeID(NetConfPara.class, Arrays.asList(neID), false);
        NetConfPara oldPara = paras.isEmpty() ? null : (NetConfPara)paras.iterator().next();
        NetConfPara newPara = new NetConfPara();
        int iReturn = -1;
        if (oldPara != null) {
            this.copy(newPara, oldPara);
            newPara.setUserName(userName);
            newPara.setPassword(pwd);
            iReturn = this.netConfHandler.modifySessionPool(newPara.getDevIP(), newPara);
            if (iReturn != 0) {
                return iReturn;
            }
            if (!isOffLine) {
                AdapterInfo adapterInfo = new AdapterInfo(neID);
                List infos = Activator.getMessageTempletService().getSessionCheckMessages(adapterInfo);
                iReturn = this.netConfHandler.testPoolCommunicate(newPara.getDevIP(), newPara, infos);
                if (iReturn != 0) {
                    this.netConfHandler.modifySessionPool(oldPara.getDevIP(), oldPara);
                }
            }
            if (iReturn == 0 || isOffLine) {
                record.addModify((Object)newPara, Arrays.asList("password", "userName"));
                dao.merge(NetConfPara.class, false);
                iReturn = 0;
            }
        }
        return iReturn;
    }

    public int setDefaultNetConfPara(int devID) throws NetconfException {
        try {
            NetconfTemplate defaultTemplate = new NetconfTemplate();
            defaultTemplate.setTemplateID(Integer.valueOf(1));
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            Collection defaults = dao.queryByKey(NetconfTemplate.class, Arrays.asList(defaultTemplate), false);
            if (!defaults.isEmpty()) {
                NetconfTemplate template = (NetconfTemplate)defaults.iterator().next();
                NetConfPara para = this.getParaByTemplate(template);
                para.setDevID(Integer.valueOf(devID));
                return this.setNetConfPara(para);
            }
            return 1107498867;
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public void setNetConfHandler(NetconfCommHandler netConfHandler) {
        this.netConfHandler = netConfHandler;
    }

    public int setNetConfPara(NetConfPara para) throws NetconfException {
        try {
            if (null == para.getDevIP()) {
                String devIP = Activator.getDeviceService().getDevIPByID(para.getDevID().intValue());
                para.setDevIP(devIP);
            }
            Context ctx = new Context();
            ctx.addChangeRecord(NetConfPara.class).addCreate((Object)para);
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
            dao.merge(NetConfPara.class, false);
            int result = this.initialSessionPool(para.getDevIP(), para);
            if (0 == result) {
                this.notifySyncData(para);
            }
            return result;
        }
        catch (VMFException e) {
            log.error("setNetConfPara failed", (Throwable)e);
            return e.getErrorCode();
        }
    }

    public int setNetConfParaByTemplate(int devID, int templateID) throws NetconfException {
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            NetconfTemplate template = new NetconfTemplate();
            template.setTemplateID(Integer.valueOf(templateID));
            Collection templates = dao.queryByKey(NetconfTemplate.class, Arrays.asList(template), false);
            if (templates.isEmpty()) {
                template.setTemplateID(Integer.valueOf(1));
                templates = dao.queryByKey(NetconfTemplate.class, Arrays.asList(template), false);
            }
            if (templates.isEmpty()) {
                return 1107498867;
            }
            template = (NetconfTemplate)templates.iterator().next();
            NetConfPara para = this.getParaByTemplate(template);
            para.setDevID(Integer.valueOf(devID));
            return this.setNetConfPara(para);
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public int setNetConfParaByTemplate(int devID, String templateName) throws NetconfException {
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            NetconfTemplate template = new NetconfTemplate();
            template.setTemplateID(Integer.valueOf(templateName.hashCode()));
            Collection templates = dao.queryByKey(NetconfTemplate.class, Arrays.asList(template), false);
            if (templates.isEmpty()) {
                template.setTemplateID(Integer.valueOf(1));
                templates = dao.queryByKey(NetconfTemplate.class, Arrays.asList(template), false);
            }
            if (templates.isEmpty()) {
                return 1107498867;
            }
            template = (NetconfTemplate)templates.iterator().next();
            NetConfPara para = this.getParaByTemplate(template);
            para.setDevID(Integer.valueOf(devID));
            return this.setNetConfPara(para);
        }
        catch (VMFException e) {
            throw new NetconfException(-1, (Throwable)e);
        }
    }

    public int setNetConfParaForV5V8Transfer(NetConfPara para) {
        try {
            String decryptPwd = para.getPassword();
            Context ctx = new Context();
            ctx.addChangeRecord(NetConfPara.class).addCreate((Object)para);
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
            dao.merge(NetConfPara.class, false);
            para.setPassword(decryptPwd);
            return this.initialSessionPool(para.getDevIP(), para);
        }
        catch (VMFException e) {
            log.info("getNetconfhandler().createSessionPool ", (Throwable)e);
            return e.getErrorCode();
        }
    }

    private void copy(NetConfPara destPara, NetConfPara srcPara) {
        destPara.setDevID(srcPara.getDevID());
        destPara.setDevIP(srcPara.getDevIP());
        destPara.setAuthMode(srcPara.getAuthMode());
        destPara.setLoginTimeout(srcPara.getLoginTimeout());
        destPara.setPassword(srcPara.getPassword());
        destPara.setPort(srcPara.getPort());
        destPara.setPrivateKey(srcPara.getPrivateKey());
        destPara.setResponseTimeout(srcPara.getResponseTimeout());
        destPara.setUserName(srcPara.getUserName());
        destPara.setPasswordPhrase(srcPara.getPasswordPhrase());
    }

    private NetConfPara getParaByTemplate(NetconfTemplate template) {
        NetConfPara netconfPara = new NetConfPara();
        netconfPara.setAuthMode(template.getAuthMode());
        netconfPara.setUserName(template.getUserName());
        netconfPara.setPassword(template.getPassword());
        netconfPara.setPrivateKey(template.getPrivateKey());
        netconfPara.setLoginTimeout(template.getLoginTimeout());
        netconfPara.setResponseTimeout(template.getResponseTimeout());
        netconfPara.setPort(template.getPort());
        return netconfPara;
    }

    private int initialSessionPool(String devIP, NetConfPara para) {
        int result = this.getNetConfHandler().createSessionPool(devIP, para);
        log.info("getNetconfhandler().createSessionPool " + result);
        return result;
    }

    private void notifySyncData(NetConfPara para) {
        IEventManager eventManager = Activator.getEventManager();
        log.info("getEventManager().sendEvent " + eventManager);
        if (null != eventManager) {
            try {
                eventManager.publishEvent((IEvent)new ObjectEvent("com.huawei.vmf.netconf.para.eventNETCONF_PARA_SUCCESS_DEVID", para.getDevID().intValue()));
            }
            catch (EventExcpetion e) {
                log.error("publishEvent failed.", (Throwable)e);
            }
        } else {
            log.error(" getEventManager is NULL ");
        }
    }
}

