/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.WriteLog;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetconfTemplate;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfTmplReq;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfTmplResp;
import com.huawei.vmf.netconf.para.asn.translator.NetConfParaTranslator;
import com.huawei.vmf.netconf.para.internal.ModifyNetconfParaTemplateIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyNetconfParaTemplateImpl
extends AbstractNetConfParaOper
implements ModifyNetconfParaTemplateIF {
    private Logger log = LoggerFactory.getLogger(ModifyNetconfParaTemplateImpl.class);

    @Override
    public void modifyNetconfParaTemplate(AsnConfNetconfTmplReq req, AsnConfNetconfTmplResp rsp, MSGHead head) {
        int userID = req.iUserID.intValue();
        NetconfTemplate template = NetConfParaTranslator.decodeAsnNetconfTemplate(req.oNetconfTmpl);
        int iReturn = 0;
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
        try {
            Collection old = dao.queryByKey(NetconfTemplate.class, Arrays.asList(template), false);
            if (old.isEmpty()) {
                iReturn = 1107498867;
            } else {
                Collection fields = dao.getPersistentProperties(NetconfTemplate.class);
                ctx.addChangeRecord(NetconfTemplate.class).addModify((Object)template, fields);
                dao.merge(NetconfTemplate.class, false);
            }
        }
        catch (VMFException e) {
            this.log.error("Error occurs when modify netconf template.", (Throwable)e);
            iReturn = e.getErrorCode();
        }
        if (iReturn != 0) {
            this.log.error("Error occurs when modify netconf template para.");
        }
        rsp.oResult.iCode = BigInteger.valueOf(iReturn);
        int result = 0 == iReturn ? 0 : 2;
        int cmdID = head.cmdCode;
        Long ipAddr = head.senderProcIP;
        String operateDesc = WriteLog.getString((String)"templatename") + template.getTemplateName();
        this.writeNmsOperLog(userID, cmdID, iReturn, result, ipAddr, operateDesc);
    }
}

