/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.WriteLog;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetconfTemplate;
import com.huawei.vmf.nemgr.asn.netconf.AsnDelTemplReq;
import com.huawei.vmf.nemgr.asn.netconf.AsnResIDLst;
import com.huawei.vmf.nemgr.asn.netconf.AsnResult;
import com.huawei.vmf.netconf.para.internal.DelNetconfParaTemplateIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelNetconfParaTemplateImpl
extends AbstractNetConfParaOper
implements DelNetconfParaTemplateIF {
    private Logger log = LoggerFactory.getLogger(DelNetconfParaTemplateImpl.class);

    @Override
    public void delNetconfParaTemplate(AsnDelTemplReq req, AsnResult rsp, MSGHead head) {
        block5: {
            rsp.iCode = BigInteger.valueOf(0L);
            AsnResIDLst templateIDlist = req.lstTemplateID;
            Vector<NetconfTemplate> templateIDs = new Vector<NetconfTemplate>(templateIDlist.size());
            for (Object object : templateIDlist) {
                NetconfTemplate template = new NetconfTemplate();
                template.setTemplateID(Integer.valueOf(((BigInteger)object).intValue()));
                templateIDs.add(template);
            }
            int userID = req.iUserID.intValue();
            Long ipAddr = head.senderProcIP;
            int cmdID = head.cmdCode;
            Collection templates = null;
            Context ctx = new Context();
            ctx.addChangeRecord(NetconfTemplate.class).addDelete(templateIDs);
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
            try {
                templates = dao.queryByKey(NetconfTemplate.class, templateIDs, false);
                dao.merge(NetconfTemplate.class, false);
                for (NetconfTemplate netconfTemplate : templates) {
                    String operateDesc = WriteLog.getString((String)"templatename") + netconfTemplate.getTemplateName();
                    this.writeNmsOperLog(userID, cmdID, 0, 0, ipAddr, operateDesc);
                }
            }
            catch (VMFException e) {
                this.log.error("Error occurs when delete netconf template.", (Throwable)e);
                rsp.iCode = BigInteger.valueOf(e.getErrorCode());
                if (templates == null) break block5;
                for (NetconfTemplate netconfTemplate : templates) {
                    String operateDesc = WriteLog.getString((String)"templatename") + netconfTemplate.getTemplateName();
                    this.writeNmsOperLog(userID, cmdID, e.getErrorCode(), 2, ipAddr, operateDesc);
                }
            }
        }
    }
}

