/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.service.impl;

import com.huawei.communicate.core.MSGHead;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.WriteLog;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetconfTemplate;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfTmplReq;
import com.huawei.vmf.nemgr.asn.netconf.AsnConfNetconfTmplResp;
import com.huawei.vmf.nemgr.asn.netconf.AsnNetconfTemplate;
import com.huawei.vmf.netconf.para.asn.translator.NetConfParaTranslator;
import com.huawei.vmf.netconf.para.internal.AddNetconfParaTemplateIF;
import com.huawei.vmf.netconf.para.service.impl.AbstractNetConfParaOper;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNetconfParaTemplateImpl
extends AbstractNetConfParaOper
implements AddNetconfParaTemplateIF {
    private static final Logger log = LoggerFactory.getLogger(AddNetconfParaTemplateImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNetconfTemplate(AsnConfNetconfTmplReq req, AsnConfNetconfTmplResp rsp, MSGHead head) {
        int userID = req.iUserID.intValue();
        AsnNetconfTemplate anstemplate = req.oNetconfTmpl;
        NetconfTemplate template = NetConfParaTranslator.decodeAsnNetconfTemplate(anstemplate);
        Context ctx = new Context();
        ctx.addChangeRecord(NetconfTemplate.class).addCreate((Object)template);
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", ctx, null);
        int ret = 1107498880;
        try {
            dao.merge(NetconfTemplate.class, false);
            ret = 0;
        }
        catch (VMFException e) {
            try {
                ret = e.getErrorCode();
                log.error("Error occurs when insert template data into database.", (Throwable)e);
            }
            catch (Throwable throwable) {
                rsp.oResult.iCode = BigInteger.valueOf(ret);
                int result = 0 == ret ? 0 : 2;
                int cmdID = head.cmdCode;
                Long ipAddr = head.senderProcIP;
                String operateDesc = WriteLog.getString((String)"templatename") + template.getTemplateName();
                this.writeNmsOperLog(userID, cmdID, ret, result, ipAddr, operateDesc);
                throw throwable;
            }
            rsp.oResult.iCode = BigInteger.valueOf(ret);
            int result = 0 == ret ? 0 : 2;
            int cmdID = head.cmdCode;
            Long ipAddr = head.senderProcIP;
            String operateDesc = WriteLog.getString((String)"templatename") + template.getTemplateName();
            this.writeNmsOperLog(userID, cmdID, ret, result, ipAddr, operateDesc);
        }
        rsp.oResult.iCode = BigInteger.valueOf(ret);
        int result = 0 == ret ? 0 : 2;
        int cmdID = head.cmdCode;
        Long ipAddr = head.senderProcIP;
        String operateDesc = WriteLog.getString((String)"templatename") + template.getTemplateName();
        this.writeNmsOperLog(userID, cmdID, ret, result, ipAddr, operateDesc);
    }
}

