/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.notify;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.AbstractMOChangeListener;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DeviceDeleteChangeListener
extends AbstractMOChangeListener {
    private static final List<Class<DevSysInfo>> MOTYPES = Arrays.asList(DevSysInfo.class);

    public Collection getTrackMoType() {
        return MOTYPES;
    }

    public void handleChanges(Context context) throws VMFException {
        Set deleteDevices = context.getChangeRecord(DevSysInfo.class).getDeletes();
        if (CollectionUtils.isEmpty((Collection)deleteDevices)) {
            return;
        }
        Context deleteContext = new Context();
        IMOChangeRecord moChangeRecord = deleteContext.addChangeRecord(NetConfPara.class);
        for (DevSysInfo deleteDevice : deleteDevices) {
            NetConfPara mo = new NetConfPara();
            mo.setDevID(deleteDevice.getDevID());
            moChangeRecord.addDelete((Object)mo);
        }
        IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", deleteContext, null);
        try {
            dao.merge(true, new Class[]{NetConfPara.class});
        }
        catch (Exception e) {
            this.getLogger().error("Delete NetConfPara mo error while delete device. ", (Throwable)e);
        }
    }
}

