/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para.asn.translator;

import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetconfTemplate;
import com.huawei.vmf.common.tool.FrameCihperTool;
import com.huawei.vmf.common.tool.PlatformCipherTool;
import com.huawei.vmf.nemgr.asn.netconf.AsnNetconfBasePara;
import com.huawei.vmf.nemgr.asn.netconf.AsnNetconfTemplate;
import java.math.BigInteger;

public class NetConfParaTranslator {
    private NetConfParaTranslator() {
    }

    public static NetConfPara decodeAsnNetconfBasePara(AsnNetconfBasePara asn) {
        NetConfPara netConfPara = new NetConfPara();
        netConfPara.setAuthMode(Integer.valueOf(asn.iAuthMode.intValue()));
        netConfPara.setLoginTimeout(Integer.valueOf(asn.iLoginTimeout.intValue()));
        netConfPara.setPort(Integer.valueOf(asn.iPort.intValue()));
        netConfPara.setResponseTimeout(Integer.valueOf(asn.iResponseTimeout.intValue()));
        netConfPara.setUserName(StringUtil.globalString((byte[])asn.strLoginUser));
        byte[] tmpPassword = FrameCihperTool.decrypt((byte[])asn.strLoginPwd);
        String platformEnPassword = PlatformCipherTool.encrypt((byte[])tmpPassword);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPassword);
        netConfPara.setPassword(platformEnPassword);
        netConfPara.setPrivateKey(StringUtil.globalString((byte[])asn.strUsePrivateKey));
        if (null == netConfPara.getPrivateKey() || "".equals(netConfPara.getPrivateKey())) {
            netConfPara.setPrivateKey(" ");
            netConfPara.setPasswordPhrase("");
        } else {
            byte[] tmpPasswordPhrase = FrameCihperTool.decrypt((byte[])asn.passwordPhrase);
            String platformEnPasswordPhrase = PlatformCipherTool.encrypt((byte[])tmpPasswordPhrase);
            com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPasswordPhrase);
            netConfPara.setPasswordPhrase(platformEnPasswordPhrase);
        }
        return netConfPara;
    }

    public static AsnNetconfBasePara encodeAsnNetconfBasePara(NetConfPara netConfPara) {
        AsnNetconfBasePara asn = new AsnNetconfBasePara();
        asn.iAuthMode = BigInteger.valueOf(netConfPara.getAuthMode().intValue());
        asn.iLoginTimeout = BigInteger.valueOf(netConfPara.getLoginTimeout().intValue());
        asn.iResponseTimeout = BigInteger.valueOf(netConfPara.getResponseTimeout().intValue());
        byte[] tmpPassword = PlatformCipherTool.decrypt((String)netConfPara.getPassword());
        byte[] frameEnPassword = FrameCihperTool.encrypt((byte[])tmpPassword);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPassword);
        asn.strLoginPwd = frameEnPassword;
        asn.strLoginUser = StringUtil.globalByte((String)netConfPara.getUserName());
        asn.iPort = BigInteger.valueOf(netConfPara.getPort().intValue());
        asn.strUsePrivateKey = StringUtil.globalByte((String)netConfPara.getPrivateKey());
        byte[] tmpPasswordPhrase = PlatformCipherTool.decrypt((String)netConfPara.getPasswordPhrase());
        byte[] frameEnPasswordPhrase = FrameCihperTool.encrypt((byte[])tmpPasswordPhrase);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPasswordPhrase);
        asn.passwordPhrase = frameEnPasswordPhrase;
        return asn;
    }

    public static NetconfTemplate decodeAsnNetconfTemplate(AsnNetconfTemplate asn) {
        NetconfTemplate entity = new NetconfTemplate();
        entity.setTemplateName(StringUtil.globalString((byte[])asn.strTemplName));
        if (asn.iTemplID == null || asn.iTemplID.intValue() < 0) {
            entity.setTemplateID(Integer.valueOf(entity.getTemplateName().hashCode()));
        } else {
            entity.setTemplateID(Integer.valueOf(asn.iTemplID.intValue()));
        }
        entity.setAuthMode(Integer.valueOf(asn.oNetconfBasePara.iAuthMode.intValue()));
        entity.setUserName(StringUtil.globalString((byte[])asn.oNetconfBasePara.strLoginUser));
        byte[] tmpPassword = FrameCihperTool.decrypt((byte[])asn.oNetconfBasePara.strLoginPwd);
        String platformEnPassword = PlatformCipherTool.encrypt((byte[])tmpPassword);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPassword);
        entity.setPassword(platformEnPassword);
        entity.setPrivateKey(StringUtil.globalString((byte[])asn.oNetconfBasePara.strUsePrivateKey));
        byte[] tmpPasswordPhrase = FrameCihperTool.decrypt((byte[])asn.oNetconfBasePara.passwordPhrase);
        entity.setPasswordPhrase(PlatformCipherTool.encrypt((byte[])tmpPasswordPhrase));
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPasswordPhrase);
        if ("".equals(entity.getPrivateKey()) || null == entity.getPrivateKey()) {
            entity.setPrivateKey(" ");
        }
        entity.setLoginTimeout(Integer.valueOf(asn.oNetconfBasePara.iLoginTimeout.intValue()));
        entity.setResponseTimeout(Integer.valueOf(asn.oNetconfBasePara.iResponseTimeout.intValue()));
        if (asn.oNetconfBasePara.iPort.intValue() <= 0) {
            entity.setPort(Integer.valueOf(22));
        } else {
            entity.setPort(Integer.valueOf(asn.oNetconfBasePara.iPort.intValue()));
        }
        return entity;
    }

    public static AsnNetconfTemplate encodeAsnNetconfTemplatesn(NetconfTemplate entity) {
        AsnNetconfTemplate asn = new AsnNetconfTemplate();
        asn.iTemplID = BigInteger.valueOf(entity.getTemplateID().intValue());
        asn.strTemplName = StringUtil.globalByte((String)entity.getTemplateName());
        asn.oNetconfBasePara.iAuthMode = BigInteger.valueOf(entity.getAuthMode().intValue());
        asn.oNetconfBasePara.iLoginTimeout = BigInteger.valueOf(entity.getLoginTimeout().intValue());
        asn.oNetconfBasePara.iResponseTimeout = BigInteger.valueOf(entity.getResponseTimeout().intValue());
        byte[] tmpPassword = PlatformCipherTool.decrypt((String)entity.getPassword());
        byte[] frameEnPassword = FrameCihperTool.encrypt((byte[])tmpPassword);
        com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPassword);
        asn.oNetconfBasePara.strLoginPwd = frameEnPassword;
        asn.oNetconfBasePara.strLoginUser = StringUtil.globalByte((String)entity.getUserName());
        asn.oNetconfBasePara.iPort = BigInteger.valueOf(entity.getPort().intValue());
        if (null != entity.getPrivateKey()) {
            asn.oNetconfBasePara.strUsePrivateKey = StringUtil.globalByte((String)entity.getPrivateKey());
            byte[] tmpPasswordPhrase = PlatformCipherTool.decrypt((String)entity.getPasswordPhrase());
            asn.oNetconfBasePara.passwordPhrase = FrameCihperTool.encrypt((byte[])tmpPasswordPhrase);
            com.huawei.vmf.common.tool.StringUtil.clearBytes((byte[])tmpPasswordPhrase);
        }
        return asn;
    }
}

