/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.para;

import com.huawei.uflight.event.client.IEventManager;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.common.AbstractBundleActivator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.INotifyListener;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.messagetemplet.service.MessageTempletIF;
import com.huawei.vmf.adapter.fservice.netconf.para.model.NetConfPara;
import com.huawei.vmf.netconf.para.notify.DeviceDeleteChangeListener;
import com.huawei.vmf.netconf.para.service.impl.NetconfCommHandler;
import com.huawei.vmf.netconf.para.task.NetConfParaTask;
import java.util.ArrayList;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Activator
extends AbstractBundleActivator
implements ApplicationContextAware {
    private static ApplicationContext context;
    private static IEventManager eventManager;
    private static Logger logger;

    public Activator() {
        super(Activator.getNetconfTaskClass(), null);
    }

    public static IDeviceService getDeviceService() {
        return (IDeviceService)context.getBean(IDeviceService.class);
    }

    public static IEventManager getEventManager() {
        if (null == eventManager) {
            eventManager = (IEventManager)context.getBean("eventManagerService");
        }
        return eventManager;
    }

    public static MessageTempletIF getMessageTempletService() {
        return (MessageTempletIF)context.getBean(MessageTempletIF.class);
    }

    public static Collection<Class<?>> getNetconfTaskClass() {
        ArrayList col = new ArrayList(1);
        col.add(NetConfParaTask.class);
        return col;
    }

    public static void setContext(ApplicationContext context) {
        Activator.context = context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Activator.setContext(applicationContext);
    }

    public void start(BundleContext context) throws Exception {
        logger.debug("NetConfPara bundle start begin");
        super.start(context);
        MOChangePublisher.getInstance().registry((INotifyListener)new DeviceDeleteChangeListener());
        this.init();
        logger.debug("NetConfPara bundle start finish");
    }

    public void stop(BundleContext context) throws Exception {
        logger.debug("NetConfPara bundle stop begin");
        super.stop(context);
        logger.debug("NetConfPara bundle stop finish");
    }

    private void init() {
        NetconfCommHandler handler = new NetconfCommHandler();
        try {
            IDao dao = DaoFactory.getInstance().getExtendDao("ucommonDB", null, null);
            if (null == dao) {
                return;
            }
            Collection paras = dao.queryAll(NetConfPara.class, false);
            if (paras != null) {
                for (NetConfPara netConfPara : paras) {
                    netConfPara.setPassword(netConfPara.getPassword());
                    this.initialSessionPool(netConfPara.getDevIP(), netConfPara, handler);
                }
            }
        }
        catch (VMFException e) {
            logger.error("init exception.", (Throwable)e);
        }
    }

    private int initialSessionPool(String devIP, NetConfPara para, NetconfCommHandler handler) {
        int result = handler.createSessionPool(devIP, para);
        logger.info("getNetconfhandler().createSessionPool: " + result);
        return result;
    }

    static {
        logger = LoggerFactory.getLogger(Activator.class);
    }
}

