/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnTunnelSvrRelationInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsSwitchPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.vpls.fdn.VplsPwFdnParser;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public abstract class QAsnTunnelSvrRelationInfoTranslator<MOType extends VmfMO>
extends OnlyEncodeAsnTranslator<QAsnTunnelSvrRelationInfo, MOType> {
    public void encode(MOType mo, QAsnTunnelSvrRelationInfo asn, IAsnTranslationContext context) throws VMFException {
        this.encodeTunnelKey(mo, asn, context);
        this.encodeServiceKey(mo, asn, context);
    }

    public Class<QAsnTunnelSvrRelationInfo> getAsnClass() {
        return QAsnTunnelSvrRelationInfo.class;
    }

    protected void encodeServiceKey(MOType mo, QAsnTunnelSvrRelationInfo asn, IAsnTranslationContext context) {
        List l3vpnInstances = mo.getKeyRefMos(L3vpnInstance.class);
        List ldpPws = mo.getKeyRefMos(VpwsPw.class);
        List switchLdpPws = mo.getKeyRefMos(VpwsSwitchPw.class);
        List vsiPws = mo.getKeyRefMos(VplsLdpPw.class);
        if (!CollectionUtils.isEmpty((Collection)l3vpnInstances)) {
            L3vpnInstance instance = (L3vpnInstance)l3vpnInstances.iterator().next();
            L3vpnInstanceFdnParser serviceFdnParser = new L3vpnInstanceFdnParser();
            asn.serviceKey = serviceFdnParser.getUniResID((VmfMO)instance);
        } else if (!CollectionUtils.isEmpty((Collection)ldpPws)) {
            VpwsPw instance = (VpwsPw)ldpPws.iterator().next();
            VpwsPwFdnParser serviceFdnParser = new VpwsPwFdnParser();
            asn.serviceKey = serviceFdnParser.getUniResID((VmfMO)instance);
        } else if (!CollectionUtils.isEmpty((Collection)switchLdpPws)) {
            VpwsSwitchPw instance = (VpwsSwitchPw)switchLdpPws.iterator().next();
            VpwsSwitchPwFdnParser serviceFdnParser = new VpwsSwitchPwFdnParser();
            asn.serviceKey = serviceFdnParser.getUniResID((VmfMO)instance);
        } else if (!CollectionUtils.isEmpty((Collection)vsiPws)) {
            VplsLdpPw vsiPw = (VplsLdpPw)vsiPws.iterator().next();
            VplsPwFdnParser serviceFdnParser = new VplsPwFdnParser();
            asn.serviceKey = serviceFdnParser.getUniResID((VmfMO)vsiPw);
        }
    }

    protected abstract void encodeTunnelKey(MOType var1, QAsnTunnelSvrRelationInfo var2, IAsnTranslationContext var3);
}

