/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.ProGroupRSVPTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.TunnelGroupFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelKeyInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelPGInfoTranslator;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnTunnelPGInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTunnelPGInfoTranslator> {
    public static final int NOREVER_MODE_SATUS_E2E = 0;
    public static final int NOREVER_MODE_STATUS_ROUTER = 2;
    public static final int REVER_MODE_STATUS_E2E = 1;
    public static final int REVER_MODE_STATUS_ROUTER = 1;

    public void decodeIRevertiveMode(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
        if (EOperationType.CREATE == context.getOperType()) {
            if (1 == asn.iRevertiveMode) {
                mo.setRevertiveMode(Integer.valueOf(1));
            } else {
                mo.setRevertiveMode(Integer.valueOf(2));
            }
        } else if (EOperationType.MODIFY == context.getOperType()) {
            if (0 == asn.iRevertiveMode) {
                mo.setRevertiveMode(Integer.valueOf(2));
            } else {
                mo.setRevertiveMode(Integer.valueOf(1));
            }
        } else {
            mo.setRevertiveMode(Integer.valueOf(asn.iRevertiveMode));
        }
    }

    public void decodeKeyProperties(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
        mo.setDevID(Integer.valueOf(asn.oProtectionGrouplKey.neID));
        if (!StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.oProtectionGrouplKey.strFDN))) {
            TunnelGroupFdnParser parser = new TunnelGroupFdnParser();
            TunnelGroup moIndex = (TunnelGroup)parser.getIndexMo(asn.oProtectionGrouplKey);
            if (moIndex != null) {
                mo.setDevID(moIndex.getDevID());
                mo.setVrID(moIndex.getVrID());
                mo.setWorkingTunnel(moIndex.getWorkingTunnel());
            }
        } else {
            mo.setWorkingTunnel(AsnUtil.strValue((Integer)asn.iProtectionGroupID));
        }
    }

    public void decodeKeyRefMoRsvpTeTunnel(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnTunnelPGInfoSpecKeys(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelFdnParser parser;
        RsvpTeTunnel moIndex;
        if (!StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.oPrimaryForwardTunnelKey.oTunnelKey.strFDN)) && null != (moIndex = (RsvpTeTunnel)(parser = new RsvpTeTunnelFdnParser()).getIndexMo(asn.oPrimaryForwardTunnelKey.oTunnelKey))) {
            mo.setWorkingTunnel(moIndex.getTunnelName());
        }
        if (!StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.oSecondaryForwardTunnelKey.oTunnelKey.strFDN)) && null != (moIndex = (RsvpTeTunnel)(parser = new RsvpTeTunnelFdnParser()).getIndexMo(asn.oSecondaryForwardTunnelKey.oTunnelKey))) {
            mo.setProtectTunnel(moIndex.getTunnelName());
        }
    }

    public void encodeIRevertiveMode(TunnelGroup mo, QAsnTunnelPGInfo asn, IAsnTranslationContext context) throws VMFException {
        if (TunnelGroup.REVERTIVE_MODE_ENUM.REVERTIVE.equals(mo.getRevertiveMode())) {
            asn.iRevertiveMode = 1;
        } else if (TunnelGroup.REVERTIVE_MODE_ENUM.NON_REVERTIVE.equals(mo.getRevertiveMode())) {
            asn.iRevertiveMode = 0;
        }
    }

    public void encodeKeyProperties(TunnelGroup mo, QAsnTunnelPGInfo asn, IAsnTranslationContext context) throws VMFException {
        QAsnUniResID newFdnAsn = new TunnelGroupFdnParser().getUniResID((VmfMO)mo);
        asn.oProtectionGrouplKey.neID = mo.getDevID();
        asn.oProtectionGrouplKey.strFDN = newFdnAsn.strFDN;
        asn.oProtectionGrouplKey.strMOC = newFdnAsn.strMOC;
        context.addProperty(TunnelGroup.class.getName(), (Object)mo);
    }

    public void encodeKeyRefMoRsvpTeTunnel(TunnelGroup mo, QAsnTunnelPGInfo asn, IAsnTranslationContext context) throws VMFException {
        List tunnels = mo.getKeyRefMos(RsvpTeTunnel.class);
        if (CollectionUtils.isEmpty((Collection)tunnels)) {
            return;
        }
        RsvpTeTunnel maintunnel = null;
        RsvpTeTunnel backupTunnel = null;
        for (RsvpTeTunnel tunnel : tunnels) {
            String tunnelName = tunnel.getTunnelName();
            if (tunnelName.equals(mo.getWorkingTunnel())) {
                maintunnel = tunnel;
                continue;
            }
            if (!tunnelName.equals(mo.getProtectTunnel())) continue;
            backupTunnel = tunnel;
        }
        this.convertTunnelInfoToAsn(mo, maintunnel, backupTunnel, asn);
    }

    private void convertBackupTunnelInfoToAsn(TunnelGroup tunnelGroup, RsvpTeTunnel backupTunnelKeyInfo, QAsnTunnelPGInfo asnTunnelPGInfo, QAsnTunnelKeyInfo asnMainTunnelKeyInfo) throws VMFException {
        QAsnTunnelKeyInfoTranslator tunnelKeyInfoTranslator = new QAsnTunnelKeyInfoTranslator();
        QAsnTunnelKeyInfo asnBackupTunnelKeyInfo = new QAsnTunnelKeyInfo();
        tunnelKeyInfoTranslator.encode(backupTunnelKeyInfo, asnBackupTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
        asnBackupTunnelKeyInfo.iPosition = 1;
        asnBackupTunnelKeyInfo.iBindingTnlIf = 1;
        asnBackupTunnelKeyInfo.strIngressLsrID = asnMainTunnelKeyInfo.strIngressLsrID;
        asnTunnelPGInfo.oSecondaryForwardTunnelKey = asnBackupTunnelKeyInfo;
        boolean bMajorIsBidirectional = backupTunnelKeyInfo.getBiDirectional();
        String egressLSRId = backupTunnelKeyInfo.getMplsTunnelEgressLSRId();
        String ingressLSRId = backupTunnelKeyInfo.getMplsTunnelIngressLSRId();
        QAsnTunnelKeyInfo asnBackupReserveTunnelKeyInfo = new QAsnTunnelKeyInfo();
        if (bMajorIsBidirectional) {
            asnTunnelPGInfo.oSecondaryReverseTunnelKey = asnBackupTunnelKeyInfo;
        } else if (backupTunnelKeyInfo.getPassiveTunnel().booleanValue()) {
            backupTunnelKeyInfo.setMplsTunnelIngressLSRId(egressLSRId);
            backupTunnelKeyInfo.setMplsTunnelEgressLSRId(ingressLSRId);
            tunnelKeyInfoTranslator.encode(backupTunnelKeyInfo, asnBackupReserveTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
            asnBackupReserveTunnelKeyInfo.iPosition = 3;
            asnBackupReserveTunnelKeyInfo.iBindingTnlIf = asnBackupTunnelKeyInfo.iBindingTnlIf;
            this.setReserveTunnelKey(tunnelGroup, backupTunnelKeyInfo, asnBackupReserveTunnelKeyInfo, 3);
            asnTunnelPGInfo.oSecondaryReverseTunnelKey = asnBackupReserveTunnelKeyInfo;
        } else if (null != backupTunnelKeyInfo.getBindBiStaticLspName()) {
            backupTunnelKeyInfo.setMplsTunnelIngressLSRId(egressLSRId);
            backupTunnelKeyInfo.setMplsTunnelEgressLSRId(ingressLSRId);
            tunnelKeyInfoTranslator.encode(backupTunnelKeyInfo, asnBackupReserveTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
            asnBackupReserveTunnelKeyInfo.iPosition = 3;
            asnBackupReserveTunnelKeyInfo.iBindingTnlIf = 0;
            this.setReserveTunnelKey(tunnelGroup, backupTunnelKeyInfo, asnBackupReserveTunnelKeyInfo, null);
            asnTunnelPGInfo.oSecondaryReverseTunnelKey = asnBackupReserveTunnelKeyInfo;
        }
    }

    private void convertTunnelInfoToAsn(TunnelGroup tunnelGroup, RsvpTeTunnel mainTunnelKeyInfo, RsvpTeTunnel backupTunnelKeyInfo, QAsnTunnelPGInfo asnTunnelPGInfo) throws VMFException {
        if (null == mainTunnelKeyInfo || null == backupTunnelKeyInfo) {
            return;
        }
        QAsnTunnelKeyInfoTranslator tunnelKeyInfoTranslator = new QAsnTunnelKeyInfoTranslator();
        QAsnTunnelKeyInfo asnMainTunnelKeyInfo = new QAsnTunnelKeyInfo();
        tunnelKeyInfoTranslator.encode(mainTunnelKeyInfo, asnMainTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
        asnMainTunnelKeyInfo.iBindingTnlIf = 1;
        asnMainTunnelKeyInfo.iPosition = 1;
        asnTunnelPGInfo.poDeployStatus = mainTunnelKeyInfo.getDeployStatus();
        asnTunnelPGInfo.oPrimaryForwardTunnelKey = asnMainTunnelKeyInfo;
        boolean bMajorIsBidirectional = mainTunnelKeyInfo.getBiDirectional();
        String egressLSRId = mainTunnelKeyInfo.getMplsTunnelEgressLSRId();
        String ingressLSRId = mainTunnelKeyInfo.getMplsTunnelIngressLSRId();
        QAsnTunnelKeyInfo asnMainReserveTunnelKeyInfo = new QAsnTunnelKeyInfo();
        if (bMajorIsBidirectional) {
            asnTunnelPGInfo.oPrimaryReverseTunnelKey = asnMainTunnelKeyInfo;
        } else if (mainTunnelKeyInfo.getPassiveTunnel().booleanValue()) {
            mainTunnelKeyInfo.setMplsTunnelIngressLSRId(egressLSRId);
            mainTunnelKeyInfo.setMplsTunnelEgressLSRId(ingressLSRId);
            tunnelKeyInfoTranslator.encode(mainTunnelKeyInfo, asnMainReserveTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
            asnMainReserveTunnelKeyInfo.iPosition = 3;
            asnMainReserveTunnelKeyInfo.iBindingTnlIf = asnMainTunnelKeyInfo.iBindingTnlIf;
            this.setReserveTunnelKey(tunnelGroup, mainTunnelKeyInfo, asnMainReserveTunnelKeyInfo, 3);
            asnTunnelPGInfo.oPrimaryReverseTunnelKey = asnMainReserveTunnelKeyInfo;
        } else if (null != mainTunnelKeyInfo.getBindBiStaticLspName()) {
            mainTunnelKeyInfo.setMplsTunnelIngressLSRId(egressLSRId);
            mainTunnelKeyInfo.setMplsTunnelEgressLSRId(ingressLSRId);
            tunnelKeyInfoTranslator.encode(mainTunnelKeyInfo, asnMainReserveTunnelKeyInfo, (IAsnTranslationContext)new AsnTranslationContext());
            asnMainReserveTunnelKeyInfo.iPosition = 3;
            asnMainReserveTunnelKeyInfo.iBindingTnlIf = 0;
            this.setReserveTunnelKey(tunnelGroup, mainTunnelKeyInfo, asnMainReserveTunnelKeyInfo, null);
            asnTunnelPGInfo.oPrimaryReverseTunnelKey = asnMainReserveTunnelKeyInfo;
        }
        this.convertBackupTunnelInfoToAsn(tunnelGroup, backupTunnelKeyInfo, asnTunnelPGInfo, asnMainTunnelKeyInfo);
    }

    private void setReserveTunnelKey(TunnelGroup tempTunnelGroup, RsvpTeTunnel tunnelKeyInfo, QAsnTunnelKeyInfo asnReserveTunnelKeyInfo, Integer position) {
        ProGroupRSVPTeTunnelFdnParser parser = new ProGroupRSVPTeTunnelFdnParser();
        parser.setPosition(position);
        asnReserveTunnelKeyInfo.oTunnelKey.neID = tempTunnelGroup.getDevID();
        asnReserveTunnelKeyInfo.oTunnelKey.strFDN = AsnUtil.getBytes((String)parser.getFdn(tunnelKeyInfo));
        asnReserveTunnelKeyInfo.oTunnelKey.strMOC = AsnUtil.getBytes((String)"TUNNEL");
    }
}

