/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelOAMInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnTunnelOAMInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTunnelOAMInfoTranslator> {
    public void decodeICVFFDStatus(QAsnTunnelOAMInfo asn, MplsOamTunnel mo, IAsnTranslationContext context) {
        if (ASN_ICVFFDSTATUS.DISABLE == asn.iCVFFDStatus || MplsOamTunnel.OAM_ACTIVE_STATE_ENUM.DEACTIVE == asn.iOAMEnable) {
            mo.setReceiveEnable(Boolean.valueOf(false));
            mo.setSendEnable(Boolean.valueOf(false));
        } else {
            mo.setReceiveEnable(Boolean.valueOf(true));
            mo.setSendEnable(Boolean.valueOf(true));
        }
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(MplsOamTunnel.class);
        recorder.addModify((Object)mo, new PropertyChangeItem("sendEnable", null, null));
    }

    public void decodeIOAMEnable(QAsnTunnelOAMInfo asn, MplsOamTunnel mo, IAsnTranslationContext context) {
    }

    public void decodeKeyProperties(QAsnTunnelOAMInfo asn, MplsOamTunnel mo, IAsnTranslationContext context) {
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        MplsOamTunnel indexMo = (MplsOamTunnel)fdnParser.getIndexMo(asn.oOAMKey);
        mo.setDevID(indexMo.getDevID());
        mo.setVrID(indexMo.getVrID());
        if ("".equals(indexMo.getTunnelName())) {
            IFdnParser<StaticTunnel> tunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
            StaticTunnel tunnel = (StaticTunnel)tunnelFdnParser.getIndexMo(asn.oOAMKey);
            mo.setTunnelName(MplsUtil.calStaticTunnelName(tunnel.getIngressLsrId(), tunnel.getTunnelId(), tunnel.getEgressLsrId(), tunnel.getLsrRole()));
        } else {
            mo.setTunnelName(indexMo.getTunnelName());
        }
    }

    public void encodeICVFFDStatus(MplsOamTunnel mo, QAsnTunnelOAMInfo asn, IAsnTranslationContext context) {
        asn.iCVFFDStatus = ASN_ICVFFDSTATUS.DISABLE;
        if (mo.getSendEnable() != null && mo.getSendEnable().booleanValue()) {
            asn.iCVFFDStatus = ASN_ICVFFDSTATUS.ENABLE;
        }
    }

    public void encodeIOAMEnable(MplsOamTunnel mo, QAsnTunnelOAMInfo asn, IAsnTranslationContext context) {
        asn.iOAMEnable = mo.getOamActiveState();
    }

    public void encodeKeyProperties(MplsOamTunnel mo, QAsnTunnelOAMInfo asn, IAsnTranslationContext context) {
        StaticTunnelFdnParser fdnParser = new StaticTunnelFdnParser();
        StaticTunnel staticTunnel = new StaticTunnel();
        staticTunnel.setDevID(mo.getDevID());
        staticTunnel.setVrID(mo.getVrID());
        staticTunnel.setTunnelName(mo.getTunnelName());
        ArrayList<StaticTunnel> staticTunnels = new ArrayList<StaticTunnel>();
        staticTunnels.add(staticTunnel);
        IDao dao = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null);
        Collection tunnels = null;
        try {
            tunnels = dao.queryByKey(StaticTunnel.class, staticTunnels, true);
        }
        catch (VMFException e) {
            e.printStackTrace();
        }
        if (null != tunnels && !CollectionUtils.isEmpty((Collection)tunnels)) {
            asn.oOAMKey = fdnParser.getUniResID((VmfMO)tunnels.iterator().next());
        } else {
            MplsOamTunnelFdnParser oamFdnParser = new MplsOamTunnelFdnParser();
            asn.oOAMKey = oamFdnParser.getUniResID((VmfMO)mo);
        }
    }

    public static final class ASN_ICVFFDSTATUS {
        public static final Integer DISABLE = 0;
        public static final Integer ENABLE = 1;
    }
}

