/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelExPathAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelExPathAttrTranslator;

public class QAsnTunnelExPathAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTunnelExPathAttrTranslator> {
    public void decodeIType(QAsnTunnelExPathAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnTunnelExPathAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnTunnelExPathAttrSpecKeys(QAsnTunnelExPathAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeStrName(QAsnTunnelExPathAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint rsvpTeTunnelPathConstraint = mo.getRsvpTeTunnelPathConstraint();
        if (null == rsvpTeTunnelPathConstraint) {
            rsvpTeTunnelPathConstraint = new RsvpTeTunnelPathConstraint();
            mo.setRsvpTeTunnelPathConstraint(rsvpTeTunnelPathConstraint);
        }
        String pathName = AsnUtil.strValue((byte[])asn.strName);
        EOperationType operType = context.getOperType();
        if (EOperationType.GET.equals((Object)operType)) {
            if (1 == asn.iType) {
                rsvpTeTunnelPathConstraint.setPrimaryExplicitPathName(pathName);
            } else if (2 == asn.iType) {
                rsvpTeTunnelPathConstraint.setHotStandbyExplicitPathName(pathName);
                rsvpTeTunnelPathConstraint.setOrdinaryExplicitPathName(pathName);
            }
            return;
        }
        switch (asn.iType) {
            case 1: {
                rsvpTeTunnelPathConstraint.setPrimaryExplicitPathName(AsnTranslatorUtil.strValue((byte[])asn.strName, (String)"primaryExplicitPathName", (Object[][])null, (VmfMO)mo, (IAsnTranslationContext)context));
                break;
            }
            case 2: {
                RsvpTeTunnelAdv rsvpTeTunnelAdv = mo.getRsvpTeTunnelAdv();
                if (null == rsvpTeTunnelAdv) {
                    return;
                }
                Boolean hotStandbyEnable = rsvpTeTunnelAdv.getHotStandbyEnable();
                Boolean ordinaryEnable = rsvpTeTunnelAdv.getOrdinaryEnable();
                if (Boolean.TRUE.equals(hotStandbyEnable)) {
                    rsvpTeTunnelPathConstraint.setHotStandbyExplicitPathName(AsnTranslatorUtil.strValue((byte[])asn.strName, (String)"bestEffortExplicitPathName", (Object[][])null, (VmfMO)mo, (IAsnTranslationContext)context));
                }
                if (!Boolean.TRUE.equals(ordinaryEnable)) break;
                rsvpTeTunnelPathConstraint.setOrdinaryExplicitPathName(AsnTranslatorUtil.strValue((byte[])asn.strName, (String)"ordinaryExplicitPathName", (Object[][])null, (VmfMO)mo, (IAsnTranslationContext)context));
                break;
            }
            default: {
                this.getLogger().info("QAsnTunnelExPathAttr.iType is invalidate, iType=" + asn.iType);
            }
        }
    }

    public void encodeIType(RsvpTeTunnel mo, QAsnTunnelExPathAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnTunnelExPathAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeStrName(RsvpTeTunnel mo, QAsnTunnelExPathAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint rsvpTeTunnelPathConstraint = mo.getRsvpTeTunnelPathConstraint();
        if (null == rsvpTeTunnelPathConstraint) {
            return;
        }
        asn.iEnable = 1;
        if (null != rsvpTeTunnelPathConstraint.getPrimaryExplicitPathName()) {
            asn.iType = 1;
            asn.strName = AsnUtil.getBytes((String)rsvpTeTunnelPathConstraint.getPrimaryExplicitPathName());
        }
        if (null != rsvpTeTunnelPathConstraint.getHotStandbyExplicitPathName()) {
            asn.iType = 2;
            asn.strName = AsnUtil.getBytes((String)rsvpTeTunnelPathConstraint.getHotStandbyExplicitPathName());
        }
        if (null != rsvpTeTunnelPathConstraint.getOrdinaryExplicitPathName()) {
            asn.iType = 2;
            asn.strName = AsnUtil.getBytes((String)rsvpTeTunnelPathConstraint.getOrdinaryExplicitPathName());
        }
    }

    private static final class ITYPE_ENUM {
        private static final int PRIMARY = 1;
        private static final int STANDBY = 2;

        private ITYPE_ENUM() {
        }
    }
}

