/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnAddress;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelBaseTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class QAsnTunnelBaseSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTunnelBaseTranslator> {
    private static final int IP_ADDRESS_CONFLICT = 2;
    private static final int IP_ADDRESS_NO_CHANGE = 1;
    private static final int IP_ADDRESS_NOT_EXIST = 0;
    private final IFdnParser<RsvpTeTunnel> fdnParser = new RsvpTeTunnelFdnParser();
    private IAsnTranslator<QAsnAddress, Interface> qasnAddressTranslator;

    public void decodeIBackupStatus(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setTunnelState(AsnTranslatorUtil.integerValue((int)asn.iBackupStatus, (String)"tunnelState", (Object[][])QAsnTunnelBaseTranslator.z_rsvpTeTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIPolicyBinding(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) {
        mo.setResvForBinding(AsnTranslatorUtil.parseBoolean((Integer)asn.iPolicyBinding, (String)"resvForBinding", (Object[][])QAsnTunnelBaseTranslator.z_rsvpTeTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeKeyProperties(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel indexMo = (RsvpTeTunnel)this.fdnParser.getIndexMo(asn.oTunnelKey);
        mo.setDevID(indexMo.getDevID());
        mo.setVrID(indexMo.getVrID());
        mo.setSerialNum(indexMo.getSerialNum());
        mo.setTunnelName(indexMo.getTunnelName());
        mo.setFdn(indexMo.getFdn());
        if (null != asn.poVrID) {
            mo.setVrID(asn.poVrID);
        }
    }

    public void decodePoTnlIfIP(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        Collection queryIfms;
        if (!this.hasIfArrt(asn) || !EOperationType.PREDEPLOY.equals((Object)context.getOperType())) {
            return;
        }
        Interface ifm = MplsUtil.translate2Interface(mo);
        context.addProperty(Interface.class.getName(), (Object)ifm);
        mo.addKeyRefMo((VmfMO)ifm);
        MplsDao dao = MplsDao.newInstance();
        Context transactionContext = context.getTransactionContext();
        try {
            queryIfms = dao.queryByKey(Interface.class, CommonUtil.genList((Object[])new Interface[]{ifm}), true);
        }
        catch (VMFException e) {
            this.getLogger().error("query interface error. ifm=" + ifm, (Throwable)e);
            transactionContext.addMoOperResult((VmfMO)ifm, e.getErrorCode());
            return;
        }
        IMOChangeRecord ifmRecord = transactionContext.addChangeRecord(Interface.class);
        IAsnTranslator<QAsnAddress, Interface> asnTranslator = this.getQasnAddressTranslator();
        if (asn.poTnlIfIP != null) {
            try {
                asnTranslator.decode((FStruct)asn.poTnlIfIP, (Object)ifm, context);
            }
            catch (VMFException e) {
                this.getLogger().error("query interface error. ifm=" + ifm, (Throwable)e);
                transactionContext.addMoOperResult((VmfMO)ifm, e.getErrorCode());
                return;
            }
        }
        if (CollectionUtils.isEmpty((Collection)queryIfms)) {
            ifm.setDeployStatus(Integer.valueOf(0));
            this.decodeIfDesc(asn, ifm, null);
            ifmRecord.addCreate((Object)ifm);
            return;
        }
        Interface dbIfm = (Interface)queryIfms.iterator().next();
        ifm.setDeployStatus(dbIfm.getDeployStatus());
        this.decodeIfDesc(asn, ifm, (IMOChangeRecord<Interface>)ifmRecord);
        int checkResult = this.checkIPAddressConflict(ifm, dbIfm);
        if (checkResult == 2) {
            context.getTransactionContext().addMoOperResult((VmfMO)mo, 570425587);
            this.getLogger().error("ipaddr conflict, ifm = {}", (Object)dbIfm);
            return;
        }
        IMOChangeRecord addressRecord = context.getTransactionContext().addChangeRecord(Ipv4Address.class);
        if (checkResult == 1) {
            ifmRecord.cancelModify((Object)ifm, "unNumIfName");
            ifmRecord.cancelModify((Object)ifm, "ipv4Addresss");
            ifm.setIpv4Addresss(null);
            return;
        }
        if (!StringUtil.isEmpty((String)ifm.getUnNumIfName())) {
            ifmRecord.addModify((Object)ifm, new PropertyChangeItem("unNumIfName"));
            ifm.setIpv4Addresss(null);
        } else {
            ifmRecord.addModify((Object)ifm, new PropertyChangeItem("ipv4Addresss"));
            addressRecord.addCreate(ifm.getIpv4Addresss());
        }
    }

    public void decodeStrDestinationIP(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel dbTunnel;
        MplsDao dao;
        Collection dbTunnels;
        boolean isDestinationIPChanged;
        String destinationIP = StringUtil.globalString((byte[])asn.strDestinationIP);
        mo.setMplsTunnelEgressLSRId(destinationIP);
        boolean bl = isDestinationIPChanged = asn.poOperMask != null && (asn.poOperMask & 1) > 0;
        if (context.getOperType() == EOperationType.MODIFY && isDestinationIPChanged && !CollectionUtils.isEmpty((Collection)(dbTunnels = (dao = MplsDao.newInstance()).queryByKey(RsvpTeTunnel.class, CommonUtil.genList((Object[])new RsvpTeTunnel[]{mo}), false))) && !(dbTunnel = (RsvpTeTunnel)dbTunnels.iterator().next()).getMplsTunnelEgressLSRId().equals(destinationIP)) {
            IMOChangeRecord record = context.getTransactionContext().getChangeRecord(RsvpTeTunnel.class);
            record.addModify((Object)mo, new PropertyChangeItem("mplsTunnelEgressLSRId"));
        }
    }

    public void encodeIBackupStatus(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iBackupStatus = AsnUtil.intValue((Integer)mo.getTunnelState());
    }

    public void encodeIBindingTnlIf(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iBindingTnlIf = 1;
    }

    public void encodeIFRRStatus(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iFRRStatus = 0;
    }

    public void encodeIPolicyBinding(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) {
        asn.iPolicyBinding = AsnUtil.intValue((Boolean)mo.getResvForBinding());
    }

    public void encodeIPosition(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iPosition = 1;
    }

    public void encodeISignalType(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iSignalType = 4;
    }

    public void encodeITransportType(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iTransportType = 1;
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.oTunnelKey = this.fdnParser.getUniResID((VmfMO)mo);
        asn.poVrID = mo.getVrID();
    }

    public void encodePoDirection(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.poDirection = 0;
    }

    public void encodePoTnlIfIP(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        List infs = mo.getKeyRefMos(Interface.class);
        if (CollectionUtils.isEmpty((Collection)infs)) {
            return;
        }
        Interface inf = (Interface)infs.iterator().next();
        asn.strDescription = StringUtil.globalByte((String)inf.getIfDescr());
        if (CollectionUtils.isEmpty((Collection)inf.getIpv4Addresss())) {
            return;
        }
        if (null == asn.poTnlIfIP) {
            asn.poTnlIfIP = new QAsnAddress();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poTnlIfIP);
        }
        this.getQasnAddressTranslator().encode((Object)inf, (FStruct)asn.poTnlIfIP, context);
    }

    public void encodeStrEgressLsrID(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.strEgressLsrID = AsnUtil.getBytes((String)mo.getMplsTunnelEgressLSRId());
    }

    private int checkIPAddressConflict(Interface newIf, Interface oldIf) {
        if (!StringUtil.isEmpty((String)newIf.getUnNumIfName())) {
            if (ObjectUtils.equals((Object)newIf.getUnNumIfName(), (Object)oldIf.getUnNumIfName())) {
                return 1;
            }
            return StringUtil.isEmpty((String)oldIf.getUnNumIfName()) && CollectionUtils.isEmpty((Collection)oldIf.getIpv4Addresss()) ? 0 : 2;
        }
        if (!CollectionUtils.isEmpty((Collection)newIf.getIpv4Addresss())) {
            if (!StringUtil.isEmpty((String)oldIf.getUnNumIfName())) {
                return 2;
            }
            if (CollectionUtils.isEmpty((Collection)oldIf.getIpv4Addresss())) {
                return 0;
            }
            return this.isAllIpAddrExist(oldIf.getIpv4Addresss(), newIf.getIpv4Addresss()) ? 1 : 2;
        }
        return 1;
    }

    private void decodeIfDesc(QAsnTunnelBase asn, Interface mo, IMOChangeRecord<Interface> ifmRecord) {
        if (asn.strDescription != null && asn.strDescription.length > 0) {
            mo.setIfDescr(AsnUtil.strValue((byte[])asn.strDescription));
            if (ifmRecord != null) {
                ifmRecord.addModify((Object)mo, Arrays.asList("ifDescr"));
            }
        }
    }

    private IAsnTranslator<QAsnAddress, Interface> getQasnAddressTranslator() {
        if (null == this.qasnAddressTranslator) {
            this.qasnAddressTranslator = Activator.getAsnTranslator(QAsnAddress.class, Interface.class);
        }
        return this.qasnAddressTranslator;
    }

    private boolean hasIfArrt(QAsnTunnelBase asn) {
        if (asn.strDescription != null && asn.strDescription.length > 0) {
            return true;
        }
        return asn.poTnlIfIP != null && (null != asn.poTnlIfIP.poUnnumbered || !CollectionUtils.isEmpty((Collection)asn.poTnlIfIP.addrList));
    }

    private boolean isAllIpAddrExist(Collection<Ipv4Address> existIpAddress, Collection<Ipv4Address> newIpAddress) {
        for (Ipv4Address newIp : newIpAddress) {
            boolean isEqual = false;
            for (Ipv4Address oldIp : existIpAddress) {
                if (!ObjectUtils.equals((Object)oldIp.getIpAddr(), (Object)newIp.getIpAddr()) || !ObjectUtils.equals((Object)oldIp.getSubnetMask(), (Object)newIp.getSubnetMask()) || !ObjectUtils.equals((Object)oldIp.getAddrType(), (Object)newIp.getAddrType())) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            return false;
        }
        return true;
    }
}

