/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLspHopForStaticTunnelTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelBaseForStaticTunnelTranslator;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnTunnelBaseForStaticTunnelSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTunnelBaseForStaticTunnelTranslator> {
    private IFdnParser<StaticTunnel> staticTunnFdnParser = MplsUtil.getStaticTunnelFdnParser();

    public void decodeIBindingTnlIf(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeIPosition(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeISignalType(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeITransportType(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn.oTunnelKey == null) {
            return;
        }
        MplsAsnUtil.decodeStaticCRTunnelKeys(asn.oTunnelKey, mo, context);
    }

    public void decodePoDirection(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null != asn.poDirection) {
            mo.setDirection(AsnTranslatorUtil.integerValue((Integer)asn.poDirection, (String)"direction", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodeStrDescription(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setTunnelDescription(new String(asn.strDescription));
    }

    public void decodeUserLabel(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setUserLabel(AsnTranslatorUtil.strValue((byte[])asn.userLabel, (String)"userLabel", (Object[][])QAsnTunnelBaseForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void encodeIBindingTnlIf(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iBindingTnlIf = 1;
    }

    public void encodeIPosition(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iPosition = mo.getLsrRole();
    }

    public void encodeISignalType(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iSignalType = 1;
    }

    public void encodeITransportType(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.iTransportType = 1;
    }

    public void encodeKeyProperties(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.oTunnelKey = this.staticTunnFdnParser.getUniResID((VmfMO)mo);
        asn.oTunnelKey.poSerialNum = AsnUtil.getBytes((String)mo.getSerialNum());
    }

    public void encodePoDirection(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.poDirection = mo.getDirection();
    }

    public void encodeStrDescription(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.strDescription = AsnUtil.getBytes((String)mo.getTunnelDescription());
    }

    public void encodeUserLabel(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        asn.userLabel = AsnUtil.getBytes((String)mo.getUserLabel());
    }

    public void decodeStrTunnelName(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) {
        String tunnelName = AsnUtil.strValue((byte[])asn.strTunnelName);
        if (StringUtil.isEmpty((String)tunnelName) && MplsUtil.isPtn() && context.getOperType() == EOperationType.PREDEPLOY) {
            mo.setTunnelName(MplsUtil.calStaticTunnelName(mo.getIngressLsrId(), mo.getTunnelId(), mo.getEgressLsrId(), mo.getLsrRole()));
            if (context.getOperType() == EOperationType.PREDEPLOY && StaticTunnel.LSR_ROLE_ENUM.TRANSIT != mo.getLsrRole()) {
                Collection queryIfms;
                Interface ifm = new Interface();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ifm);
                ifm.setIfName(mo.getTunnelName());
                ifm.setDeployStatus(Integer.valueOf(0));
                MplsDao dao = MplsDao.newInstance();
                Context transactionContext = context.getTransactionContext();
                try {
                    queryIfms = dao.queryByKey(Interface.class, CommonUtil.genList((Object[])new Interface[]{ifm}), true);
                }
                catch (VMFException e) {
                    this.getLogger().error("query interface error. ifm=" + ifm, (Throwable)e);
                    transactionContext.addMoOperResult((VmfMO)ifm, e.getErrorCode());
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)queryIfms)) {
                    IMOChangeRecord ifmRecord = context.getTransactionContext().addChangeRecord(Interface.class);
                    MplsUtil.setIfmFdn(Arrays.asList(ifm));
                    ifmRecord.addCreate((Object)ifm);
                    mo.addKeyRefMo((VmfMO)ifm);
                }
            }
        }
    }

    public void encodeStrTunnelName(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) {
        asn.strTunnelName = MplsUtil.isPtn() ? "".getBytes() : AsnUtil.getBytes((String)mo.getTunnelName());
    }
}

