/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicy;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyAttr;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyBinding;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyBindingList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TpNexthop;
import com.huawei.vmf.adapter.fservice.mpls.model.TpTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTnlPolicyKeyTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class QAsnTnlPolicyTranslator
extends AbstractAsnTranslator<QAsnTnlPolicy, TunnelPolicy> {
    public static final Object[][] z_qasnTnlPolicyAttrMasks = new Object[0][];
    public static final Object[][] z_tunnelPolicyMasks = new Object[0][];

    public void decode(QAsnTnlPolicy asn, TunnelPolicy mo, IAsnTranslationContext context) throws VMFException {
        QAsnTnlPolicyKeyTranslator keyTranslator = new QAsnTnlPolicyKeyTranslator();
        if (asn.tnlPolicyKey != null) {
            keyTranslator.decode(asn.tnlPolicyKey, mo, context);
        }
        if (this.isDelete(0, null, context)) {
            return;
        }
        if (asn.tnlPolicyAttr != null) {
            mo.setLoadBalanceNum(this.longValue(asn.tnlPolicyAttr.loadbalanceNumber, "loadBalanceNum", z_tunnelPolicyMasks, (VmfMO)mo, context));
            this.decodeSelectSequence(asn.tnlPolicyAttr, mo, context);
            if (asn.tnlPolicyAttr.bindings != null) {
                this.decodeBindings(asn.tnlPolicyAttr.bindings, mo, context);
            }
        }
        this.decodeTnlPolicyType(asn.tnlPolicyAttr, mo, context);
    }

    public void decodeSelectSequence(QAsnTnlPolicyAttr asn, TunnelPolicy mo, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)asn.selectSequence)) {
            return;
        }
        if (asn.selectSequence.size() == 1) {
            if (2 == (Integer)asn.selectSequence.get(0)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.INVAILD);
            } else if (1 == (Integer)asn.selectSequence.get(0)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.INVAILD);
            }
        } else if (asn.selectSequence.size() == 2) {
            if (2 == (Integer)asn.selectSequence.get(0) && 1 == (Integer)asn.selectSequence.get(1)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP_CR_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.CR_LSP);
            } else if (1 == (Integer)asn.selectSequence.get(0) && 2 == (Integer)asn.selectSequence.get(1)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.LSP);
            }
        }
    }

    public void encode(TunnelPolicy mo, QAsnTnlPolicy asn, IAsnTranslationContext context) throws VMFException {
        QAsnTnlPolicyKeyTranslator keyTranslator = new QAsnTnlPolicyKeyTranslator();
        keyTranslator.encode(mo, asn.tnlPolicyKey, context);
        if (mo.getLoadBalanceNum() != null && mo.getLoadBalanceNum() > 0L) {
            asn.tnlPolicyAttr.loadbalanceNumber = this.intValue(mo.getLoadBalanceNum());
        }
        this.encodeSelectSequence(mo, asn.tnlPolicyAttr, context);
        if (ObjectUtils.equals((Object)TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_BINDING, (Object)mo.getTnlPolicyType())) {
            if (asn.tnlPolicyAttr.bindings == null) {
                asn.tnlPolicyAttr.bindings = new QAsnTnlPolicyBindingList();
            }
            this.encodeBindings(mo, asn.tnlPolicyAttr.bindings, context);
        }
    }

    public void encodeSelectSequence(TunnelPolicy mo, QAsnTnlPolicyAttr asn, IAsnTranslationContext context) {
        if (!ObjectUtils.equals((Object)TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_SELECT_SEQ, (Object)mo.getTnlPolicyType())) {
            return;
        }
        if (mo.getTnlTypeSeq() == null && null == mo.getSelTnlType1() && null == mo.getSelTnlType2()) {
            return;
        }
        if (asn.selectSequence == null) {
            asn.selectSequence = new QAsnTinyIntList();
        }
        if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)2);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)1);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP_CR_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)2);
            asn.selectSequence.add((Object)1);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)1);
            asn.selectSequence.add((Object)2);
        } else if (mo.getTnlTypeSeq() == null) {
            if (TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP.equals(mo.getSelTnlType1())) {
                asn.selectSequence.add((Object)2);
            } else if (TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP.equals(mo.getSelTnlType1())) {
                asn.selectSequence.add((Object)1);
            }
            if (TunnelPolicy.SEL_TNL_TYPE2_ENUM.LSP.equals(mo.getSelTnlType2())) {
                asn.selectSequence.add((Object)2);
            } else if (TunnelPolicy.SEL_TNL_TYPE2_ENUM.CR_LSP.equals(mo.getSelTnlType2())) {
                asn.selectSequence.add((Object)1);
            }
            if (asn.selectSequence.isEmpty()) {
                asn.selectSequence.add((Object)2);
            }
        }
    }

    public Class<QAsnTnlPolicy> getAsnClass() {
        return QAsnTnlPolicy.class;
    }

    public Class<TunnelPolicy> getMoClass() {
        return TunnelPolicy.class;
    }

    private void dealNextHop(TunnelPolicy mo, TpNexthop nexthop, IAsnTranslationContext context) throws VMFException {
        Context transactionContext = context.getTransactionContext();
        TpNexthop dbTpNexthop = this.queryTpNexthopFromDb(nexthop);
        if (dbTpNexthop == null) {
            IMOChangeRecord tpNexthopRecord = transactionContext.addChangeRecord(TpNexthop.class);
            tpNexthopRecord.addCreate((Object)nexthop);
        } else {
            IMOChangeRecord tpTunnelRecord = transactionContext.addChangeRecord(TpTunnel.class);
            IMOChangeRecord tpNexthopRecord = transactionContext.addChangeRecord(TpNexthop.class);
            IMOChangeRecord tunnelPolicyRecord = transactionContext.addChangeRecord(TunnelPolicy.class);
            tunnelPolicyRecord.addModify((Object)mo, new PropertyChangeItem("tpNexthops"));
            tpNexthopRecord.addModify((Object)nexthop, new PropertyChangeItem("tpTunnels"));
            Collection tpTunnels = nexthop.getTpTunnels();
            Collection dbTpTunnels = dbTpNexthop.getTpTunnels();
            if (CollectionUtils.isEmpty((Collection)tpTunnels) && CollectionUtils.isEmpty((Collection)dbTpTunnels)) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)tpTunnels)) {
                nexthop.setTpTunnels(dbTpTunnels);
                tpTunnelRecord.addDelete(dbTpTunnels);
            } else if (CollectionUtils.isEmpty((Collection)dbTpTunnels)) {
                tpTunnelRecord.addCreate(tpTunnels);
            } else {
                for (TpTunnel tpTunnel : tpTunnels) {
                    if (dbTpTunnels.contains(tpTunnel)) continue;
                    tpTunnelRecord.addCreate((Object)tpTunnel);
                }
                for (TpTunnel dbTpTunnel : dbTpTunnels) {
                    if (tpTunnels.contains(dbTpTunnel)) continue;
                    tpTunnels.add(dbTpTunnel);
                    tpTunnelRecord.addDelete((Object)dbTpTunnel);
                }
            }
        }
    }

    private void decodeBindings(QAsnTnlPolicyBindingList bindings, TunnelPolicy mo, IAsnTranslationContext context) throws VMFException {
        HashSet<String> destinationIpSet = new HashSet<String>();
        HashMap<String, ArrayList<QAsnTnlPolicyBinding>> bindMap = new HashMap<String, ArrayList<QAsnTnlPolicyBinding>>();
        for (Object obj : bindings) {
            QAsnTnlPolicyBinding binding = (QAsnTnlPolicyBinding)obj;
            String destinationIP = StringUtil.globalString((byte[])binding.destinationIP);
            destinationIpSet.add(destinationIP);
            ArrayList<QAsnTnlPolicyBinding> bindings2 = (ArrayList<QAsnTnlPolicyBinding>)bindMap.get(destinationIP);
            if (bindings2 == null) {
                bindings2 = new ArrayList<QAsnTnlPolicyBinding>();
                bindMap.put(destinationIP, bindings2);
            }
            bindings2.add(binding);
        }
        ArrayList<TpNexthop> nexthops = mo.getTpNexthops();
        if (nexthops == null) {
            nexthops = new ArrayList<TpNexthop>();
            mo.setTpNexthops(nexthops);
        }
        RsvpTeTunnelFdnParser tunnelFdnParser = new RsvpTeTunnelFdnParser();
        for (String destinationIP : destinationIpSet) {
            TpNexthop nexthop = new TpNexthop();
            nexthop.setDevID(mo.getDevID());
            nexthop.setVrID(mo.getVrID());
            nexthop.setTnlPolicyName(mo.getTnlPolicyName());
            nexthop.setNexthopIPaddr(destinationIP);
            ArrayList<TpTunnel> tpTunnels = new ArrayList<TpTunnel>();
            for (QAsnTnlPolicyBinding binding : (List)bindMap.get(destinationIP)) {
                TpTunnel tpTunnel = new TpTunnel();
                tpTunnel.setDevID(mo.getDevID());
                tpTunnel.setVrID(mo.getVrID());
                tpTunnel.setTnlPolicyName(mo.getTnlPolicyName());
                tpTunnel.setNexthopIPaddr(destinationIP);
                RsvpTeTunnel tunnel = (RsvpTeTunnel)tunnelFdnParser.getIndexMo(binding.poTunnelKey);
                if (null == tunnel || StringUtil.isEmpty((String)tunnel.getTunnelName())) {
                    tpTunnel.setTunnelName(StringUtil.globalString((byte[])binding.tunnelIFName));
                } else {
                    tpTunnel.setTunnelName(tunnel.getTunnelName());
                    tpTunnel.addKeyRefMo((VmfMO)tunnel);
                }
                tpTunnels.add(tpTunnel);
            }
            nexthop.setTpTunnels(tpTunnels);
            nexthops.add(nexthop);
            this.dealNextHop(mo, nexthop, context);
        }
    }

    private void decodeTnlPolicyType(QAsnTnlPolicyAttr tnlPolicyAttr, TunnelPolicy mo, IAsnTranslationContext context) {
        if (tnlPolicyAttr == null) {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.INVALID);
        } else if (!CollectionUtils.isEmpty((Collection)tnlPolicyAttr.bindings)) {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_BINDING);
        } else if (!CollectionUtils.isEmpty((Collection)tnlPolicyAttr.selectSequence)) {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_SELECT_SEQ);
        } else {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.INVALID);
        }
    }

    private void encodeBindings(TunnelPolicy mo, QAsnTnlPolicyBindingList bindings, IAsnTranslationContext context) {
        ArrayList tpTunnels = new ArrayList();
        Collection tpNexthops = mo.getTpNexthops();
        if (CollectionUtils.isEmpty((Collection)tpNexthops)) {
            return;
        }
        for (TpNexthop tpNexthop : tpNexthops) {
            if (CollectionUtils.isEmpty((Collection)tpNexthop.getTpTunnels())) continue;
            tpTunnels.addAll(tpNexthop.getTpTunnels());
        }
        RsvpTeTunnelFdnParser tunnelFdnParser = new RsvpTeTunnelFdnParser();
        for (TpTunnel tpTunnel : tpTunnels) {
            QAsnTnlPolicyBinding binding = new QAsnTnlPolicyBinding();
            binding.destinationIP = StringUtil.globalByte((String)tpTunnel.getNexthopIPaddr());
            binding.tunnelIFName = StringUtil.globalByte((String)tpTunnel.getTunnelName());
            if (!StringUtil.isEmpty((String)tpTunnel.getTunnelName())) {
                RsvpTeTunnel tunnel = new RsvpTeTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tpTunnel, (VmfMO)tunnel);
                tunnel.setTunnelName(tpTunnel.getTunnelName());
                binding.poTunnelKey = tunnelFdnParser.getUniResID((VmfMO)tunnel);
            }
            bindings.add((Object)binding);
        }
    }

    private TpNexthop queryTpNexthopFromDb(TpNexthop tpNexthop) throws VMFException {
        Collection tpTunnels = MplsDao.newInstance().queryByKey(TpNexthop.class, Arrays.asList(tpNexthop), true);
        if (CollectionUtils.isEmpty((Collection)tpTunnels)) {
            return null;
        }
        return (TpNexthop)tpTunnels.iterator().next();
    }

    private static class TNL_TYPE_SEQUENCE {
        public static final int CR_LSP = 1;
        private static final int LSP = 2;

        private TNL_TYPE_SEQUENCE() {
        }
    }
}

