/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyBinding;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TpNexthop;
import com.huawei.vmf.adapter.fservice.mpls.model.TpTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTnlPolicyBindingTranslator;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnTnlPolicyBindingSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTnlPolicyBindingTranslator> {
    public void decodeKeyProperties(QAsnTnlPolicyBinding asn, TpNexthop mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeTpTunnel(QAsnTnlPolicyBinding asn, TpNexthop mo, IAsnTranslationContext context) throws VMFException {
        if (asn.poTunnelKey == null) {
            return;
        }
        RsvpTeTunnelFdnParser parser = new RsvpTeTunnelFdnParser();
        RsvpTeTunnel tunnel = (RsvpTeTunnel)parser.getIndexMo(asn.poTunnelKey);
        TpTunnel tpTunnel = new TpTunnel();
        tpTunnel.setDevID(mo.getDevID());
        tpTunnel.setVrID(mo.getVrID());
        tpTunnel.setNexthopIPaddr(mo.getNexthopIPaddr());
        tpTunnel.setTnlPolicyName(mo.getTnlPolicyName());
        tpTunnel.setTunnelName(tunnel.getTunnelName());
        mo.addTpTunnels(Arrays.asList(tpTunnel));
        if (this.isExsist(tpTunnel)) {
            return;
        }
        TpNexthop dbTpNexthop = this.queryTpNexthopFromDb(mo);
        if (dbTpNexthop != null) {
            Context transactionContext = context.getTransactionContext();
            IMOChangeRecord tpTunnelRecord = transactionContext.addChangeRecord(TpTunnel.class);
            IMOChangeRecord tpNexthopRecord = transactionContext.addChangeRecord(TpNexthop.class);
            IMOChangeRecord tunnelPolicyRecord = transactionContext.addChangeRecord(TunnelPolicy.class);
            TunnelPolicy tunnelPolicy = (TunnelPolicy)context.getProperty(TunnelPolicy.class.getName());
            tunnelPolicyRecord.addModify((Object)tunnelPolicy, new PropertyChangeItem("tpNexthops"));
            tpNexthopRecord.addModify((Object)mo, new PropertyChangeItem("tpTunnels"));
            tpTunnelRecord.addCreate((Object)tpTunnel);
            Collection dbTpTunnels = dbTpNexthop.getTpTunnels();
            if (!CollectionUtils.isEmpty((Collection)dbTpTunnels)) {
                mo.addTpTunnels(dbTpTunnels);
                tpTunnelRecord.addDelete(dbTpTunnels);
            }
        }
    }

    public void encodeKeyProperties(TpNexthop mo, QAsnTnlPolicyBinding asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeTpTunnel(TpNexthop mo, QAsnTnlPolicyBinding asn, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getTpTunnels())) {
            return;
        }
        RsvpTeTunnel tunnel = new RsvpTeTunnel();
        tunnel.setDevID(mo.getDevID());
        tunnel.setVrID(mo.getVrID());
        tunnel.setTunnelName(((TpTunnel)mo.getTpTunnels().iterator().next()).getTunnelName());
        RsvpTeTunnelFdnParser parser = new RsvpTeTunnelFdnParser();
        asn.poTunnelKey = parser.getUniResID((VmfMO)tunnel);
    }

    private boolean isExsist(TpTunnel tpTunnel) throws VMFException {
        Collection tpTunnels = MplsDao.newInstance().queryByKey(TpTunnel.class, Arrays.asList(tpTunnel), false);
        return !CollectionUtils.isEmpty((Collection)tpTunnels);
    }

    private TpNexthop queryTpNexthopFromDb(TpNexthop tpNexthop) throws VMFException {
        Collection tpTunnels = MplsDao.newInstance().queryByKey(TpNexthop.class, Arrays.asList(tpNexthop), true);
        if (CollectionUtils.isEmpty((Collection)tpTunnels)) {
            return null;
        }
        return (TpNexthop)tpTunnels.iterator().next();
    }
}

