/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTnlPolicyAttrTranslator;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnTnlPolicyAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnTnlPolicyAttrTranslator> {
    public void decodeKeyProperties(QAsnTnlPolicyAttr asn, TunnelPolicy mo, IAsnTranslationContext context) throws VMFException {
        if (!CollectionUtils.isEmpty((Collection)asn.bindings)) {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_BINDING);
        } else if (!CollectionUtils.isEmpty((Collection)asn.selectSequence)) {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_SELECT_SEQ);
        } else {
            mo.setTnlPolicyType(TunnelPolicy.TNL_POLICY_TYPE_ENUM.INVALID);
        }
    }

    public void decodeQAsnTnlPolicyAttrSpecKeys(QAsnTnlPolicyAttr asn, TunnelPolicy mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeSelectSequence(QAsnTnlPolicyAttr asn, TunnelPolicy mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.selectSequence)) {
            return;
        }
        if (asn.selectSequence.size() == 1) {
            if (2 == (Integer)asn.selectSequence.get(0)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.INVAILD);
            } else if (1 == (Integer)asn.selectSequence.get(0)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.INVAILD);
            }
        } else if (asn.selectSequence.size() == 2) {
            if (2 == (Integer)asn.selectSequence.get(0) && 1 == (Integer)asn.selectSequence.get(1)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP_CR_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.CR_LSP);
            } else if (1 == (Integer)asn.selectSequence.get(0) && 2 == (Integer)asn.selectSequence.get(1)) {
                mo.setTnlTypeSeq(TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP_LSP);
                mo.setSelTnlType1(TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP);
                mo.setSelTnlType2(TunnelPolicy.SEL_TNL_TYPE2_ENUM.LSP);
            }
        }
    }

    public void encodeKeyProperties(TunnelPolicy mo, QAsnTnlPolicyAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeSelectSequence(TunnelPolicy mo, QAsnTnlPolicyAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn.selectSequence == null) {
            asn.selectSequence = new QAsnTinyIntList();
        }
        if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)2);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)1);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.LSP_CR_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)2);
            asn.selectSequence.add((Object)1);
        } else if (TunnelPolicy.TNL_TYPE_SEQ_ENUM.CR_LSP_LSP.equals(mo.getTnlTypeSeq())) {
            asn.selectSequence.add((Object)1);
            asn.selectSequence.add((Object)2);
        } else if (mo.getTnlTypeSeq() == null) {
            if (TunnelPolicy.SEL_TNL_TYPE1_ENUM.LSP.equals(mo.getSelTnlType1())) {
                asn.selectSequence.add((Object)2);
            } else if (TunnelPolicy.SEL_TNL_TYPE1_ENUM.CR_LSP.equals(mo.getSelTnlType1())) {
                asn.selectSequence.add((Object)1);
            }
            if (TunnelPolicy.SEL_TNL_TYPE2_ENUM.LSP.equals(mo.getSelTnlType2())) {
                asn.selectSequence.add((Object)2);
            } else if (TunnelPolicy.SEL_TNL_TYPE2_ENUM.CR_LSP.equals(mo.getSelTnlType2())) {
                asn.selectSequence.add((Object)1);
            }
            if (asn.selectSequence.isEmpty()) {
                asn.selectSequence.add((Object)2);
            }
        }
    }

    private static class TNL_TYPE_SEQUENCE {
        public static final int CR_LSP = 1;
        private static final int LSP = 2;

        private TNL_TYPE_SEQUENCE() {
        }
    }
}

