/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingSwitch;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.act.RingProtectSwitch;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;

public class QAsnSPRingSwitchTranslator
extends AbstractAsnTranslator<QAsnSPRingSwitch, RingProtectSwitch> {
    private IFdnParser<MplsRing> fdnParser = new MplsRingFdnParser();

    public void decode(QAsnSPRingSwitch asn, RingProtectSwitch mo, IAsnTranslationContext context) throws VMFException {
        MplsRing ring = (MplsRing)this.fdnParser.getIndexMo(asn.ringKey);
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)ring, (VmfMO)mo);
        mo.setRingId(AsnUtil.strValue((Integer)ring.getRingId()));
        this.decodeSwitchDirection(asn, mo);
        this.decodeSwitchType(asn, mo);
    }

    private void decodeSwitchType(QAsnSPRingSwitch asn, RingProtectSwitch mo) {
        if (asn.switchType == 0) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.CLEAR);
        } else if (asn.switchType == 1) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.EXERCISE);
        } else if (asn.switchType == 7) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.FORCE);
        } else if (asn.switchType == 9) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.LOCK);
        } else if (asn.switchType == 8) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.LOCKOUT_WORK);
        } else if (asn.switchType == 2) {
            mo.setRingPsOperation(RingProtectSwitch.RING_PS_OPERATION_ENUM.MANUAL);
        } else {
            QAsnSPRingSwitchTranslator.getLogger().debug("no control!");
        }
    }

    private void decodeSwitchDirection(QAsnSPRingSwitch asn, RingProtectSwitch mo) {
        if (asn.switchDirection == 1) {
            mo.setRingDirection(RingProtectSwitch.RING_DIRECTION_ENUM.EAST);
        } else if (asn.switchDirection == 2) {
            mo.setRingDirection(RingProtectSwitch.RING_DIRECTION_ENUM.WEST);
        } else {
            QAsnSPRingSwitchTranslator.getLogger().debug("no control!");
        }
    }

    public void encode(RingProtectSwitch mo, QAsnSPRingSwitch asn, IAsnTranslationContext context) throws VMFException {
        MplsRing ring = new MplsRing();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ring);
        ring.setRingId(AsnUtil.integerValue((String)mo.getRingId()));
        asn.ringKey = this.fdnParser.getUniResID((VmfMO)ring);
        this.encodeSwitchDirection(mo, asn);
        this.encodeSwitchType(mo, asn);
    }

    private void encodeSwitchType(RingProtectSwitch mo, QAsnSPRingSwitch asn) {
        if (RingProtectSwitch.RING_PS_OPERATION_ENUM.CLEAR.equals(mo.getRingPsOperation())) {
            asn.switchType = 0;
        } else if (RingProtectSwitch.RING_PS_OPERATION_ENUM.EXERCISE.equals(mo.getRingPsOperation())) {
            asn.switchType = 1;
        } else if (RingProtectSwitch.RING_PS_OPERATION_ENUM.FORCE.equals(mo.getRingPsOperation())) {
            asn.switchType = 7;
        } else if (RingProtectSwitch.RING_PS_OPERATION_ENUM.LOCK.equals(mo.getRingPsOperation())) {
            asn.switchType = 9;
        } else if (RingProtectSwitch.RING_PS_OPERATION_ENUM.LOCKOUT_WORK.equals(mo.getRingPsOperation())) {
            asn.switchType = 8;
        } else if (RingProtectSwitch.RING_PS_OPERATION_ENUM.MANUAL.equals(mo.getRingPsOperation())) {
            asn.switchType = 2;
        } else {
            QAsnSPRingSwitchTranslator.getLogger().debug("no control!");
        }
    }

    private void encodeSwitchDirection(RingProtectSwitch mo, QAsnSPRingSwitch asn) {
        if (RingProtectSwitch.RING_DIRECTION_ENUM.EAST.equals(mo.getRingDirection())) {
            asn.switchDirection = 1;
        } else if (RingProtectSwitch.RING_DIRECTION_ENUM.WEST.equals(mo.getRingDirection())) {
            asn.switchDirection = 2;
        } else {
            QAsnSPRingSwitchTranslator.getLogger().debug("no control!");
        }
    }

    public Class<QAsnSPRingSwitch> getAsnClass() {
        return QAsnSPRingSwitch.class;
    }

    public Class<RingProtectSwitch> getMoClass() {
        return RingProtectSwitch.class;
    }

    private static class SWITCH_TYPE_ENUM {
        private static final int CLEAR = 0;
        private static final int EXER = 1;
        private static final int MS = 2;
        private static final int FS = 7;
        private static final int LW = 8;
        private static final int LP = 9;

        private SWITCH_TYPE_ENUM() {
        }
    }

    private static class SWITCH_DIRECTION_ENUM {
        private static final int EAST = 1;
        private static final int WEST = 2;

        private SWITCH_DIRECTION_ENUM() {
        }
    }
}

