/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingSwitchStatus;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingSwitchStatusTranslator;

public class QAsnSPRingSwitchStatusSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSPRingSwitchStatusTranslator> {
    private IFdnParser<MplsRing> fdnParser = new MplsRingFdnParser();

    public void decodeEastSwitchResult(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        int switchResult = this.decodeSwitchResult(asn.eastSwitchResult);
        mo.setEastSwtichResult(AsnTranslatorUtil.integerValue((int)switchResult, (String)"eastSwtichResult", (Object[][])QAsnSPRingSwitchStatusTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeEastSwitchStatus(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        int switchStatus = this.decodeSwitchState(asn.eastSwitchStatus);
        mo.setEastState(AsnTranslatorUtil.integerValue((int)switchStatus, (String)"eastState", (Object[][])QAsnSPRingSwitchStatusTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeKeyProperties(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        MplsRing temp = (MplsRing)this.fdnParser.getIndexMo(asn.ringKey);
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)temp, (VmfMO)mo);
        mo.setRingId(temp.getRingId());
        mo.setFdn(temp.getFdn());
    }

    public void decodeQAsnSPRingSwitchStatusSpecKeys(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeWestSwitchResult(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        int switchResult = this.decodeSwitchResult(asn.eastSwitchResult);
        mo.setWestSwtichResult(AsnTranslatorUtil.integerValue((int)switchResult, (String)"westSwtichResult", (Object[][])QAsnSPRingSwitchStatusTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeWestSwitchStatus(QAsnSPRingSwitchStatus asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        int switchStatus = this.decodeSwitchState(asn.westSwitchStatus);
        mo.setWestState(AsnTranslatorUtil.integerValue((int)switchStatus, (String)"westState", (Object[][])QAsnSPRingSwitchStatusTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void encodeEastSwitchResult(MplsRing mo, QAsnSPRingSwitchStatus asn, IAsnTranslationContext context) throws VMFException {
        asn.eastSwitchResult = this.encodeSwitchResult(mo.getEastSwtichResult());
    }

    public void encodeEastSwitchStatus(MplsRing mo, QAsnSPRingSwitchStatus asn, IAsnTranslationContext context) throws VMFException {
        asn.eastSwitchStatus = this.encodeSwitchState(mo.getEastState());
    }

    public void encodeKeyProperties(MplsRing mo, QAsnSPRingSwitchStatus asn, IAsnTranslationContext context) throws VMFException {
        asn.ringKey = this.fdnParser.getUniResID((VmfMO)mo);
    }

    public void encodeWestSwitchResult(MplsRing mo, QAsnSPRingSwitchStatus asn, IAsnTranslationContext context) throws VMFException {
        asn.westSwitchResult = this.encodeSwitchResult(mo.getWestSwtichResult());
    }

    public void encodeWestSwitchStatus(MplsRing mo, QAsnSPRingSwitchStatus asn, IAsnTranslationContext context) throws VMFException {
        asn.westSwitchStatus = this.encodeSwitchState(mo.getWestState());
    }

    private int decodeSwitchResult(int asnSwitchResult) {
        if (asnSwitchResult == 1) {
            return MplsRing.EAST_SWTICH_RESULT_ENUM.SWITCHED;
        }
        if (asnSwitchResult == 2) {
            return MplsRing.EAST_SWTICH_RESULT_ENUM.NO_SWITCH;
        }
        return -1;
    }

    private int encodeSwitchResult(int switchResult) {
        if (switchResult == MplsRing.EAST_SWTICH_RESULT_ENUM.SWITCHED) {
            return 1;
        }
        if (switchResult == MplsRing.EAST_SWTICH_RESULT_ENUM.NO_SWITCH) {
            return 2;
        }
        return -1;
    }

    private int decodeSwitchState(int asnSwitchState) {
        if (asnSwitchState == 0) {
            return MplsRing.EAST_STATE_ENUM.IDLE;
        }
        if (asnSwitchState == 1) {
            return MplsRing.EAST_STATE_ENUM.PASS_LP;
        }
        if (asnSwitchState == 8) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_LP;
        }
        if (asnSwitchState == 9) {
            return MplsRing.EAST_STATE_ENUM.IDLE_LW;
        }
        if (asnSwitchState == 10) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_FS;
        }
        if (asnSwitchState == 11) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_SF;
        }
        if (asnSwitchState == 12) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_SD;
        }
        if (asnSwitchState == 13) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_MS;
        }
        if (asnSwitchState == 14) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_WTR;
        }
        if (asnSwitchState == 15) {
            return MplsRing.EAST_STATE_ENUM.SWITCH_EXER;
        }
        if (asnSwitchState == 24) {
            return MplsRing.EAST_STATE_ENUM.RR_LP;
        }
        return -1;
    }

    private int encodeSwitchState(int switchState) {
        if (switchState == MplsRing.EAST_STATE_ENUM.IDLE) {
            return 0;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.PASS_LP || switchState == MplsRing.EAST_STATE_ENUM.PASS_FS || switchState == MplsRing.EAST_STATE_ENUM.PASS_SF || switchState == MplsRing.EAST_STATE_ENUM.PASS_SD || switchState == MplsRing.EAST_STATE_ENUM.PASS_MS || switchState == MplsRing.EAST_STATE_ENUM.PASS_WTR || switchState == MplsRing.EAST_STATE_ENUM.PASS_EXER) {
            return 1;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_LP) {
            return 8;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.IDLE_LW) {
            return 9;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_FS) {
            return 10;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_SF) {
            return 11;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_SD) {
            return 12;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_MS) {
            return 13;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_WTR) {
            return 14;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.SWITCH_EXER) {
            return 15;
        }
        if (switchState == MplsRing.EAST_STATE_ENUM.RR_LP || switchState == MplsRing.EAST_STATE_ENUM.RR_FS || switchState == MplsRing.EAST_STATE_ENUM.RR_SF || switchState == MplsRing.EAST_STATE_ENUM.RR_SD || switchState == MplsRing.EAST_STATE_ENUM.RR_MS || switchState == MplsRing.EAST_STATE_ENUM.RR_WTR || switchState == MplsRing.EAST_STATE_ENUM.RR_EXER) {
            return 24;
        }
        return -1;
    }

    private static class SWITCH_STATUS_ENUM {
        public static final int RING_SWITCH_STATE_IDLE = 0;
        public static final int RING_SWITCH_STATE_PASS_THROUGH = 1;
        public static final int RING_SWITCH_STATE_LOCK_PROTION = 8;
        public static final int RING_SWITCH_STATE_LOCK_WORK = 9;
        public static final int RING_SWITCH_STATE_FORCE = 10;
        public static final int RING_SWITCH_STATE_SIGNAL_FAIL = 11;
        public static final int RING_SWITCH_STATE_SIGNAL_DEGRADE = 12;
        public static final int RING_SWITCH_STATE_MANUAL = 13;
        public static final int RING_SWITCH_STATE_WAIT_STORE = 14;
        public static final int RING_SWITCH_STATE_EXERCISE = 15;
        public static final int RING_SWITCH_STATE_REVERSEREQUEST = 24;

        private SWITCH_STATUS_ENUM() {
        }
    }

    private static class SWITCH_RESULT_ENUM {
        private static final int RING_SWITCH_RESULT_WORK = 2;
        private static final int RING_SWITCH_RESULT_PROTECT = 1;

        private SWITCH_RESULT_ENUM() {
        }
    }
}

