/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingPathAndTopoInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapNode;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingPathAndTopoInfoTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnSPRingPathAndTopoInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSPRingPathAndTopoInfoTranslator> {
    private IFdnParser<MplsRing> fdnParser = new MplsRingFdnParser();

    public void decodeKeyProperties(QAsnSPRingPathAndTopoInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        MplsRing temp = (MplsRing)this.fdnParser.getIndexMo(asn.ringKey);
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)temp, (VmfMO)mo);
        mo.setRingId(temp.getRingId());
    }

    public void decodePrvNodeID(QAsnSPRingPathAndTopoInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        RingMapNode node = new RingMapNode();
        node.setDevID(mo.getDevID());
        node.setVrID(mo.getVrID());
        node.setRingId(mo.getRingId());
        String[] fieldNames = new String[]{"devID", "vrID", "ringId"};
        Collection ringMapNodes = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByFields(RingMapNode.class, fieldNames, Arrays.asList(node), true);
        if (CollectionUtils.isEmpty((Collection)ringMapNodes)) {
            this.getLogger().error("The Special RingMapNode is not in database, devID = " + mo.getDevID() + " ringID = " + mo.getRingId());
            return;
        }
        List sortRingMapNodes = (List)ringMapNodes;
        Collections.sort(sortRingMapNodes, new ComparatorRingMapNode());
        RingMapNode lastNode = (RingMapNode)sortRingMapNodes.get(sortRingMapNodes.size() - 1);
        RingMapNode prvNode = null;
        for (RingMapNode findNode : sortRingMapNodes) {
            if (asn.prvNodeID != findNode.getNodeId()) continue;
            prvNode = findNode;
            break;
        }
        if (prvNode != null) {
            Iterator iter = sortRingMapNodes.iterator();
            while (iter.hasNext()) {
                RingMapNode findNode;
                findNode = (RingMapNode)iter.next();
                if (prvNode.getHopId() < (long)findNode.getHopId().intValue()) continue;
                iter.remove();
            }
        } else {
            this.getLogger().error("prvNode is not in database, prvNode = " + asn.prvNodeID);
            return;
        }
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(RingMapNode.class);
        ArrayList<RingMapNode> newNodes = new ArrayList<RingMapNode>();
        if (!CollectionUtils.isEmpty((Collection)sortRingMapNodes)) {
            RingMapNode addNode = (RingMapNode)mo.getRingMapNodes().iterator().next();
            addNode.setHopId(((RingMapNode)sortRingMapNodes.get(0)).getHopId());
            recorder.addModify((Object)addNode, Arrays.asList("nodeId", "lsrId"));
            newNodes.add(addNode);
            int len = sortRingMapNodes.size() - 1;
            for (int i = 0; i < len; ++i) {
                RingMapNode changeNode0 = (RingMapNode)sortRingMapNodes.get(i);
                RingMapNode changeNode1 = (RingMapNode)sortRingMapNodes.get(i + 1);
                changeNode0.setHopId(changeNode1.getHopId());
                recorder.addModify((Object)changeNode0, Arrays.asList("nodeId", "lsrId"));
                newNodes.add(changeNode0);
            }
            lastNode.setHopId(Long.valueOf(lastNode.getHopId() + 1L));
            recorder.addCreate((Object)lastNode);
            newNodes.add(lastNode);
            mo.setRingMapNodes(newNodes);
        } else {
            lastNode = (RingMapNode)mo.getRingMapNodes().iterator().next();
            lastNode.setHopId(Long.valueOf(lastNode.getHopId() + 1L));
            recorder.addCreate((Object)lastNode);
            newNodes.add(lastNode);
            mo.setRingMapNodes(newNodes);
        }
    }

    public void decodeQAsnSPRingPathAndTopoInfoSpecKeys(QAsnSPRingPathAndTopoInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyProperties(MplsRing mo, QAsnSPRingPathAndTopoInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.ringKey = this.fdnParser.getUniResID((VmfMO)mo);
    }

    public void encodePrvNodeID(MplsRing mo, QAsnSPRingPathAndTopoInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    class ComparatorRingMapNode
    implements Comparator {
        ComparatorRingMapNode() {
        }

        public int compare(Object arg0, Object arg1) {
            RingMapNode node0 = (RingMapNode)arg0;
            RingMapNode node1 = (RingMapNode)arg1;
            return node0.getHopId().compareTo(node1.getHopId());
        }
    }
}

