/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingOAMBaseTranslator;

public class QAsnSPRingOAMBaseSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSPRingOAMBaseTranslator> {
    public void decodeEnable(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
        Integer enable = null;
        if (asn.enable == -1) {
            enable = null;
        } else if (asn.enable == 1) {
            enable = Ring.OAM_ACTIVE_STATE_ENUM.ACTIVE;
        } else if (asn.enable == 0) {
            enable = Ring.OAM_ACTIVE_STATE_ENUM.DEACTIVE;
        } else {
            this.getLogger().debug("no control");
        }
        mo.setOamActiveState(AsnTranslatorUtil.integerValue((Integer)enable, (String)"oamActiveState", (Object[][])QAsnSPRingOAMBaseTranslator.z_ringMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeFrequency(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
        Integer detectFrequence = -1;
        mo.setDetectPktType(Ring.DETECT_PKT_TYPE_ENUM.FFD);
        if (FrequencyEnum.FREQUENCY3MS.equals(asn.frequency)) {
            detectFrequence = Ring.DETECT_FREQUENCE_ENUM.INTERVAL3MS;
        } else if (FrequencyEnum.FREQUENCY10MS.equals(asn.frequency)) {
            detectFrequence = Ring.DETECT_FREQUENCE_ENUM.INTERVAL10MS;
        } else if (FrequencyEnum.FREQUENCY100MS.equals(asn.frequency)) {
            detectFrequence = Ring.DETECT_FREQUENCE_ENUM.INTERVAL100MS;
        } else if (FrequencyEnum.FREQUENCY1S.equals(asn.frequency)) {
            mo.setDetectPktType(Ring.DETECT_PKT_TYPE_ENUM.CV);
            detectFrequence = Ring.DETECT_FREQUENCE_ENUM.INTERVAL1S;
        } else {
            detectFrequence = -1;
        }
        mo.setDetectFrequence(AsnTranslatorUtil.integerValue((Integer)detectFrequence, (String)"detectFrequence", (Object[][])QAsnSPRingOAMBaseTranslator.z_ringMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeKeyProperties(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeMode(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
        if (asn.mode != 1) {
            if (asn.mode == 2) {
                this.getLogger().debug("no control");
            } else {
                this.getLogger().debug("no control");
            }
        }
    }

    public void decodeQAsnSPRingOAMBaseSpecKeys(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeEnable(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        int enable = -1;
        if (mo.getOamActiveState() == null) {
            enable = -1;
        } else if (mo.getOamActiveState().equals(Ring.OAM_ACTIVE_STATE_ENUM.ACTIVE)) {
            enable = 1;
        } else if (mo.getOamActiveState().equals(Ring.OAM_ACTIVE_STATE_ENUM.ACTIVE)) {
            enable = 0;
        } else {
            this.getLogger().debug("no control");
        }
        asn.enable = enable;
    }

    public void encodeFrequency(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        int frequence = -1;
        frequence = Ring.DETECT_FREQUENCE_ENUM.INTERVAL3MS.equals(mo.getDetectFrequence()) ? FrequencyEnum.FREQUENCY3MS : (Ring.DETECT_FREQUENCE_ENUM.INTERVAL10MS.equals(mo.getDetectFrequence()) ? FrequencyEnum.FREQUENCY10MS : (Ring.DETECT_FREQUENCE_ENUM.INTERVAL100MS.equals(mo.getDetectFrequence()) ? FrequencyEnum.FREQUENCY100MS : (Ring.DETECT_FREQUENCE_ENUM.INTERVAL1S.equals(mo.getDetectFrequence()) ? FrequencyEnum.FREQUENCY1S : -1)));
        asn.frequency = frequence;
    }

    public void encodeKeyProperties(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeMode(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        asn.mode = 1;
    }

    public void encodeSd(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        asn.sd = mo.getOamLossSd().intValue();
    }

    public void encodeSf(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        asn.sf = mo.getOamLossSf().intValue();
    }

    private static class FrequencyEnum {
        public static final Integer FREQUENCY3MS = 1;
        public static final Integer FREQUENCY10MS = 2;
        public static final Integer FREQUENCY100MS = 3;
        public static final Integer FREQUENCY1S = 4;

        private FrequencyEnum() {
        }
    }

    private static class ModeEnum {
        private static final int m1711 = 1;
        private static final int m1731 = 2;

        private ModeEnum() {
        }
    }

    private static class EnableEnum {
        private static final int enable = 1;
        private static final int disable = 0;

        private EnableEnum() {
        }
    }
}

