/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingInfo;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.tpoam.model.Meg;
import com.huawei.vmf.adapter.fservice.tpoam.model.RingMe;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingOAMBaseTranslator;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnSPRingInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSPRingInfoTranslator> {
    private QAsnSPRingOAMBaseTranslator spRingOAMBaseTranslator = new QAsnSPRingOAMBaseTranslator();

    public void decodeEastRingOAM(QAsnSPRingInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRingOAM(asn.eastRingOAM, mo, context, Ring.RING_DIRECTION_ENUM.EAST);
    }

    public void decodeKeyProperties(QAsnSPRingInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeRingOAM(QAsnSPRingOAMBase asn, MplsRing mo, IAsnTranslationContext context, Integer ringDirection) throws VMFException {
        if (asn == null || asn.mode == -1) {
            return;
        }
        if (asn.mode == 2) {
            mo.setOamType(MplsRing.OAM_TYPE_ENUM.TPOAM);
        } else {
            mo.setOamType(MplsRing.OAM_TYPE_ENUM.OAM);
        }
        Ring ring = new Ring();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ring);
        ring.setRingId(BigInteger.valueOf(mo.getRingId().longValue()));
        ring.setRingDirection(ringDirection);
        this.spRingOAMBaseTranslator.decode(asn, ring, context);
        mo.addKeyRefMo((VmfMO)ring);
        if (EOperationType.CREATE == context.getOperType()) {
            Context ctx = context.getTransactionContext();
            IMOChangeRecord record = ctx.addChangeRecord(Ring.class);
            record.addCreate((Object)ring);
        }
    }

    public void decodeWestRingOAM(QAsnSPRingInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRingOAM(asn.westRingOAM, mo, context, Ring.RING_DIRECTION_ENUM.WEST);
    }

    public void encodeEastRingOAM(MplsRing mo, QAsnSPRingInfo asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRingOAM(mo, asn.eastRingOAM, context, Ring.RING_DIRECTION_ENUM.EAST);
    }

    public void encodeKeyProperties(MplsRing mo, QAsnSPRingInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeWestRingOAM(MplsRing mo, QAsnSPRingInfo asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRingOAM(mo, asn.westRingOAM, context, Ring.RING_DIRECTION_ENUM.WEST);
    }

    private void encodeRingOAM(MplsRing mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context, Integer ringDirection) throws VMFException {
        if (MplsRing.OAM_TYPE_ENUM.OAM.equals(mo.getOamType())) {
            Ring ring = this.getRing(mo, ringDirection);
            if (ring != null) {
                this.spRingOAMBaseTranslator.encode(ring, asn, context);
            }
        } else if (MplsRing.OAM_TYPE_ENUM.TPOAM.equals(mo.getOamType())) {
            RingMe ring = this.getTpRing(mo, ringDirection);
            Meg meg = this.getMegRing(mo, ring);
            if (ring != null && meg != null) {
                asn.enable = null != meg.getOamActiveState() ? meg.getOamActiveState().intValue() : Meg.OAM_ACTIVE_STATE_ENUM.DEACTIVE.intValue();
                asn.exp = meg.getCcExp();
                asn.frequency = meg.getCcInterval();
                asn.mode = 2;
                asn.sd = meg.getOamLmSd();
                asn.sf = meg.getOamLmSf();
            }
        } else {
            this.getLogger().debug("no control");
        }
    }

    private Ring getRing(MplsRing mo, Integer ringDirection) {
        List rings = mo.getKeyRefMos(Ring.class);
        if (CollectionUtils.isEmpty((Collection)rings)) {
            return null;
        }
        for (Ring ring : rings) {
            if (!ringDirection.equals(ring.getRingDirection())) continue;
            return ring;
        }
        return null;
    }

    private RingMe getTpRing(MplsRing mo, Integer ringDirection) {
        List rings = mo.getKeyRefMos(RingMe.class);
        if (CollectionUtils.isEmpty((Collection)rings)) {
            return null;
        }
        for (RingMe ring : rings) {
            int direction = ring.getRingDirection().intValue() == RingMe.RING_DIRECTION_ENUM.WEST.intValue() ? Ring.RING_DIRECTION_ENUM.WEST : Ring.RING_DIRECTION_ENUM.EAST;
            if (ringDirection != direction) continue;
            return ring;
        }
        return null;
    }

    private Meg getMegRing(MplsRing mo, RingMe ringMe) {
        List rings = mo.getKeyRefMos(Meg.class);
        if (CollectionUtils.isEmpty((Collection)rings) || null == ringMe) {
            return null;
        }
        for (Meg ring : rings) {
            if (!ringMe.getMegName().equals(ring.getMegName())) continue;
            return ring;
        }
        return null;
    }

    private static class RingOamModeEnum {
        private static final Integer MPLS_OAM = 1;
        private static final Integer TPOAM = 2;

        private RingOamModeEnum() {
        }
    }
}

