/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingIfBaseInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnSPRingIfBaseInfoTranslator
extends OnlyEncodeAsnTranslator<QAsnSPRingIfBaseInfo, Interface> {
    private final IFdnParser<Interface> fdnParser = new InterfaceFdnParser();

    public void encode(Interface mo, QAsnSPRingIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.oInterfaceKey = this.fdnParser.getUniResID((VmfMO)mo);
        asn.iInterfaceType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        List boards = mo.getKeyRefMos(Board.class);
        if (!CollectionUtils.isEmpty((Collection)boards)) {
            Board board = (Board)boards.iterator().next();
            asn.strSlotName = AsnUtil.getBytes((String)board.getName());
        }
        asn.iAdminStatus = AsnUtil.intValue((Integer)mo.getIfAdminStatus());
        asn.iRunningStatus = AsnUtil.intValue((Integer)mo.getIfOperStatus());
        Collection addrs = mo.getIpv4Addresss();
        if (!CollectionUtils.isEmpty((Collection)addrs)) {
            asn.strAddress = AsnUtil.getBytes((String)((Ipv4Address)addrs.iterator().next()).getIpAddr());
        }
        asn.strPortName = AsnUtil.getBytes((String)mo.getIfName());
        this.encodeMplsStatus(mo, asn);
    }

    private void encodeMplsStatus(Interface mo, QAsnSPRingIfBaseInfo asn) {
        int mplsStatus = 0;
        int mplsTeStatus = 0;
        MplsInterface mifm = null;
        List mifms = mo.getKeyRefMos(MplsInterface.class);
        if (CollectionUtils.isEmpty((Collection)mifms)) {
            mplsStatus = 0;
        } else {
            mplsStatus = 1;
            mifm = (MplsInterface)mifms.iterator().next();
            mplsTeStatus = mifm.getMplsTEEnable() == null || mifm.getMplsTEEnable() == false ? 1 : 0;
        }
        asn.iMplsStatus = mplsStatus;
        asn.iMplsTeStatus = mplsTeStatus;
        asn.iTunnelStatus = -1;
    }

    public Class<QAsnSPRingIfBaseInfo> getAsnClass() {
        return QAsnSPRingIfBaseInfo.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    public static class EnableEnum {
        public static final int ENABLE = 1;
        public static final int DISABLE = 0;
    }
}

