/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingBaseInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingBaseInfoTranslator;

public class QAsnSPRingBaseInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSPRingBaseInfoTranslator> {
    private static final int INVALID_EXP_VALUE = 255;
    private IFdnParser<MplsRing> mplsRingfdnParser = new MplsRingFdnParser();
    private IFdnParser<Interface> ifmFdnParser = new InterfaceFdnParser();

    public void decodeEastProtectExp(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setRingProtectionExp(AsnTranslatorUtil.integerValue((int)asn.eastProtectExp, (String)"ringProtectionExp", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeEastRemainCir(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setEastBwAvailable(AsnTranslatorUtil.longValue((byte[])asn.eastRemainCir, (String)"eastBwAvailable", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeEastWorkExp(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setRingWorkingExp(AsnTranslatorUtil.integerValue((int)asn.eastWorkExp, (String)"ringWorkingExp", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeKeyProperties(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        MplsRing temp = (MplsRing)this.mplsRingfdnParser.getIndexMo(asn.sprFDN);
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)temp, (VmfMO)mo);
        mo.setRingId(temp.getRingId());
        mo.setSerialNum(AsnUtil.strValue((byte[])asn.sprFDN.poSerialNum));
        Interface eastIfm = (Interface)this.ifmFdnParser.getIndexMo(asn.eastPort);
        mo.setEastOutIf(eastIfm.getIfName());
        Interface westIfm = (Interface)this.ifmFdnParser.getIndexMo(asn.westPort);
        mo.setWestOutIf(westIfm.getIfName());
    }

    public void decodeWestProtectExp(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setRingProtectionExp(AsnTranslatorUtil.integerValue((int)asn.westProtectExp, (String)"ringProtectionExp", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeWestRemainCir(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setWestBwAvailable(AsnTranslatorUtil.longValue((byte[])asn.westRemainCir, (String)"westBwAvailable", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeWestWorkExp(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setRingWorkingExp(AsnTranslatorUtil.integerValue((int)asn.westWorkExp, (String)"ringWorkingExp", (Object[][])QAsnSPRingBaseInfoTranslator.z_mplsRingMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void encodeEastProtectExp(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.eastProtectExp = this.encodeProtectExp(mo.getRingProtectionExp());
    }

    public void encodeEastRemainCir(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.eastRemainCir = AsnUtil.getBytes((Number)mo.getEastBwAvailable());
    }

    public void encodeEastWorkExp(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.eastWorkExp = this.encodeWorkExp(mo.getRingWorkingExp());
    }

    public void encodeKeyProperties(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.sprFDN = this.mplsRingfdnParser.getUniResID((VmfMO)mo);
        asn.sprFDN.poSerialNum = AsnUtil.getBytes((String)mo.getSerialNum());
        Interface eastIfm = new Interface();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)eastIfm);
        eastIfm.setFdn("");
        if (null == mo.getEastOutIf()) {
            eastIfm.setIfName("");
        } else {
            eastIfm.setIfName(mo.getEastOutIf());
        }
        asn.eastPort = this.ifmFdnParser.getUniResID((VmfMO)eastIfm);
        Interface westIfm = new Interface();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)westIfm);
        if (null == mo.getEastOutIf()) {
            westIfm.setIfName("");
        } else {
            westIfm.setIfName(mo.getWestOutIf());
        }
        asn.westPort = this.ifmFdnParser.getUniResID((VmfMO)westIfm);
        if (asn.poExAttrList == null) {
            asn.poExAttrList = new QAsnNVSList();
        }
        QAsnNameAndValueString userLabelExtAttr = new QAsnNameAndValueString();
        userLabelExtAttr.name = AsnUtil.getBytes((String)"userLabel");
        userLabelExtAttr.value = AsnUtil.getBytes((String)mo.getUserLabel());
        asn.poExAttrList.add((Object)userLabelExtAttr);
    }

    public void encodeWestProtectExp(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.westProtectExp = this.encodeProtectExp(mo.getRingProtectionExp());
    }

    public void encodeWestRemainCir(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.westRemainCir = AsnUtil.getBytes((Number)mo.getWestBwAvailable());
    }

    public void encodeWestWorkExp(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.westWorkExp = this.encodeWorkExp(mo.getRingWorkingExp());
    }

    private int encodeProtectExp(Integer ringProtectionExp) {
        int ret = AsnUtil.intValue((Integer)ringProtectionExp);
        return -1 == ret ? 255 : ret;
    }

    private int encodeWorkExp(Integer ringWorkingExp) {
        int ret = AsnUtil.intValue((Integer)ringWorkingExp);
        return ret == -1 ? 255 : ret;
    }
}

