/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLspKey;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteLsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.Lsp;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsTunnelARHop;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRouteLspTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnLspKeyLspTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnRouteLspSpecTranslator
extends AbstractAsnSpecTranslator<QAsnRouteLspTranslator> {
    private static final int TNLBYPASSSTATUS_AVAILABLE = 2;
    private static final int TNLBYPASSSTATUS_INUSE = 1;

    public void decodeITnlLspType(QAsnRouteLsp asn, Lsp mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnRouteLsp asn, Lsp mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyRefMoRsvpTeLsp(QAsnRouteLsp asn, Lsp mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeLstRouteHop(QAsnRouteLsp asn, Lsp mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnRouteLspSpecKeys(QAsnRouteLsp asn, Lsp mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeITnlLspType(Lsp mo, QAsnRouteLsp asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel tunnel = (RsvpTeTunnel)mo.getKeyRefMos(RsvpTeTunnel.class).iterator().next();
        RsvpTeTunnelPathConstraint constraint = tunnel.getRsvpTeTunnelPathConstraint();
        Long tunnelInstance = mo.getMplsTunnelInstance().longValue();
        asn.iTnlLspType = tunnelInstance.equals(constraint.getPrimaryLspId()) ? 1 : (tunnelInstance.equals(constraint.getHotStandbyLspId()) || tunnelInstance.equals(constraint.getBestEffortLspId()) || tunnelInstance.equals(constraint.getOrdinaryLspId()) ? 2 : -1);
    }

    public void encodeKeyProperties(Lsp mo, QAsnRouteLsp asn, IAsnTranslationContext context) throws VMFException {
        asn.oLspKey.neID = mo.getDevID();
        asn.oLspKey.poVrID = mo.getVrID();
        QAsnLspKeyLspTranslator translator = new QAsnLspKeyLspTranslator();
        asn.oLspKey = (QAsnLspKey)translator.encode(mo, context);
    }

    public void encodeKeyRefMoRsvpTeLsp(Lsp mo, QAsnRouteLsp asn, IAsnTranslationContext context) throws VMFException {
        List tunnels = mo.getKeyRefMos(RsvpTeTunnel.class);
        if (!CollectionUtils.isEmpty((Collection)tunnels)) {
            RsvpTeTunnel tunnel = (RsvpTeTunnel)tunnels.iterator().next();
            RsvpTeTunnelFdnParser parser = new RsvpTeTunnelFdnParser();
            asn.poTunnelKey = parser.getUniResID((VmfMO)tunnel);
        }
    }

    public void encodeLstRouteHop(Lsp mo, QAsnRouteLsp asn, IAsnTranslationContext context) throws VMFException {
        if (!CollectionUtils.isEmpty((Collection)mo.getMplsTunnelARHops())) {
            this.encodeRouteHops(mo, asn, context);
        }
    }

    private void encodeRouteHops(Lsp mo, QAsnRouteLsp asn, IAsnTranslationContext context) {
        ArrayList hops = new ArrayList(mo.getMplsTunnelARHops());
        Collections.sort(hops, new Comparator<MplsTunnelARHop>(){

            @Override
            public int compare(MplsTunnelARHop o1, MplsTunnelARHop o2) {
                return o1.getMplsTunnelARHopIndex().intValue() - o2.getMplsTunnelARHopIndex().intValue();
            }
        });
        for (int i = 0; i < hops.size(); ++i) {
            MplsTunnelARHop inHop;
            QAsnRouteHop asnHop = new QAsnRouteHop();
            asnHop.poOperMask = 0;
            asnHop.iLsrType = -1;
            if (i == 0) {
                asnHop.iLsrType = 1;
                MplsTunnelARHop outHop = (MplsTunnelARHop)hops.get(i);
                MplsTunnelARHop nextHop = (MplsTunnelARHop)hops.get(i + 1);
                asnHop.strHopLsrID = AsnUtil.getBytes((String)outHop.getMplsTunnelARHopIpAddr());
                asnHop.strNextHop = AsnUtil.getBytes((String)nextHop.getMplsTunnelARHopIpAddr());
                asnHop.poFrrSwitchStatus = AsnUtil.intValue((Boolean)outHop.getMplsTunnelLocalProtectInUse());
                asnHop.iOutLabel = AsnUtil.intValue((Long)nextHop.getMplsTunnelARHopLable());
                asnHop.strOutIFIP = AsnUtil.getBytes((String)outHop.getMplsTunnelARHopIpAddr());
                asnHop.iInLabel = -1;
                asnHop.strInIFIP = AsnUtil.getBytes((String)"");
            } else if (i == hops.size() - 1) {
                asnHop.iLsrType = 3;
                inHop = (MplsTunnelARHop)hops.get(i);
                asnHop.strHopLsrID = AsnUtil.getBytes((String)inHop.getMplsTunnelARHopIpAddr());
                asnHop.strNextHop = AsnUtil.getBytes((String)"");
                asnHop.poFrrSwitchStatus = AsnUtil.intValue((Boolean)inHop.getMplsTunnelLocalProtectInUse());
                asnHop.iInLabel = AsnUtil.intValue((Long)inHop.getMplsTunnelARHopLable());
                asnHop.strInIFIP = AsnUtil.getBytes((String)inHop.getMplsTunnelARHopIpAddr());
                asnHop.iOutLabel = -1;
                asnHop.strOutIFIP = AsnUtil.getBytes((String)"");
            } else {
                asnHop.iLsrType = 2;
                inHop = (MplsTunnelARHop)hops.get(i);
                MplsTunnelARHop outHop = (MplsTunnelARHop)hops.get(i + 1);
                MplsTunnelARHop nextHop = i + 2 >= hops.size() ? null : (MplsTunnelARHop)hops.get(i + 2);
                asnHop.strHopLsrID = AsnUtil.getBytes((String)outHop.getMplsTunnelARHopIpAddr());
                asnHop.strNextHop = AsnUtil.getBytes((String)(nextHop == null ? "" : nextHop.getMplsTunnelARHopIpAddr()));
                asnHop.poFrrSwitchStatus = AsnUtil.intValue((Boolean)outHop.getMplsTunnelLocalProtectInUse());
                asnHop.iInLabel = AsnUtil.intValue((Long)inHop.getMplsTunnelARHopLable());
                asnHop.strInIFIP = AsnUtil.getBytes((String)inHop.getMplsTunnelARHopIpAddr());
                asnHop.iOutLabel = AsnUtil.intValue((Long)(nextHop == null ? -1L : nextHop.getMplsTunnelARHopLable()));
                asnHop.strOutIFIP = AsnUtil.getBytes((String)outHop.getMplsTunnelARHopIpAddr());
                ++i;
            }
            asn.lstRouteHop.add((Object)asnHop);
        }
    }

    private static class LsrType {
        public static final int EGRESS = 3;
        public static final int INGRESS = 1;
        public static final int TRANSIT = 2;

        private LsrType() {
        }
    }

    public static class LspType {
        public static final int BESTEFFORT = 3;
        public static final int DISABLE = 0;
        public static final int PRIMARY = 1;
        public static final int SECONDARY = 2;
    }
}

